// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class DataStreamIndexConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamIndex>
{
	private static readonly System.Text.Json.JsonEncodedText PropIlmPolicy = System.Text.Json.JsonEncodedText.Encode("ilm_policy");
	private static readonly System.Text.Json.JsonEncodedText PropIndexMode = System.Text.Json.JsonEncodedText.Encode("index_mode");
	private static readonly System.Text.Json.JsonEncodedText PropIndexName = System.Text.Json.JsonEncodedText.Encode("index_name");
	private static readonly System.Text.Json.JsonEncodedText PropIndexUuid = System.Text.Json.JsonEncodedText.Encode("index_uuid");
	private static readonly System.Text.Json.JsonEncodedText PropManagedBy = System.Text.Json.JsonEncodedText.Encode("managed_by");
	private static readonly System.Text.Json.JsonEncodedText PropPreferIlm = System.Text.Json.JsonEncodedText.Encode("prefer_ilm");

	public override Elastic.Clients.Elasticsearch.IndexManagement.DataStreamIndex Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<string?> propIlmPolicy = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.IndexMode?> propIndexMode = default;
		LocalJsonValue<string> propIndexName = default;
		LocalJsonValue<string> propIndexUuid = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy?> propManagedBy = default;
		LocalJsonValue<bool?> propPreferIlm = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propIlmPolicy.TryReadProperty(ref reader, options, PropIlmPolicy, null))
			{
				continue;
			}

			if (propIndexMode.TryReadProperty(ref reader, options, PropIndexMode, static Elastic.Clients.Elasticsearch.IndexManagement.IndexMode? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<Elastic.Clients.Elasticsearch.IndexManagement.IndexMode>(o)))
			{
				continue;
			}

			if (propIndexName.TryReadProperty(ref reader, options, PropIndexName, null))
			{
				continue;
			}

			if (propIndexUuid.TryReadProperty(ref reader, options, PropIndexUuid, null))
			{
				continue;
			}

			if (propManagedBy.TryReadProperty(ref reader, options, PropManagedBy, static Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy>(o)))
			{
				continue;
			}

			if (propPreferIlm.TryReadProperty(ref reader, options, PropPreferIlm, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamIndex(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			IlmPolicy = propIlmPolicy.Value,
			IndexMode = propIndexMode.Value,
			IndexName = propIndexName.Value,
			IndexUuid = propIndexUuid.Value,
			ManagedBy = propManagedBy.Value,
			PreferIlm = propPreferIlm.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamIndex value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropIlmPolicy, value.IlmPolicy, null, null);
		writer.WriteProperty(options, PropIndexMode, value.IndexMode, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.IndexManagement.IndexMode? v) => w.WriteNullableValue<Elastic.Clients.Elasticsearch.IndexManagement.IndexMode>(o, v));
		writer.WriteProperty(options, PropIndexName, value.IndexName, null, null);
		writer.WriteProperty(options, PropIndexUuid, value.IndexUuid, null, null);
		writer.WriteProperty(options, PropManagedBy, value.ManagedBy, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy? v) => w.WriteNullableValue<Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy>(o, v));
		writer.WriteProperty(options, PropPreferIlm, value.PreferIlm, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteEndObject();
	}
}