// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

/// <summary>
/// <para>
/// Template equivalent of DataStreamFailureStore that allows nullable values.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.DataStreamFailureStoreTemplateConverter))]
public sealed partial class DataStreamFailureStoreTemplate
{
#if NET7_0_OR_GREATER
	public DataStreamFailureStoreTemplate()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DataStreamFailureStoreTemplate()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DataStreamFailureStoreTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If defined, it turns the failure store on/off (<c>true</c>/<c>false</c>) for this data stream. A data stream failure store
	/// that's disabled (enabled: <c>false</c>) will redirect no new failed indices to the failure store; however, it will
	/// not remove any existing data from the failure store.
	/// </para>
	/// </summary>
	public bool? Enabled { get; set; }

	/// <summary>
	/// <para>
	/// If defined, it specifies the lifecycle configuration for the failure store of this data stream.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleTemplate? Lifecycle { get; set; }
}

/// <summary>
/// <para>
/// Template equivalent of DataStreamFailureStore that allows nullable values.
/// </para>
/// </summary>
public readonly partial struct DataStreamFailureStoreTemplateDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplate Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataStreamFailureStoreTemplateDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplate instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataStreamFailureStoreTemplateDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplateDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplate instance) => new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplateDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplate(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplateDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If defined, it turns the failure store on/off (<c>true</c>/<c>false</c>) for this data stream. A data stream failure store
	/// that's disabled (enabled: <c>false</c>) will redirect no new failed indices to the failure store; however, it will
	/// not remove any existing data from the failure store.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplateDescriptor Enabled(bool? value = true)
	{
		Instance.Enabled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, it specifies the lifecycle configuration for the failure store of this data stream.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplateDescriptor Lifecycle(Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleTemplate? value)
	{
		Instance.Lifecycle = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, it specifies the lifecycle configuration for the failure store of this data stream.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplateDescriptor Lifecycle()
	{
		Instance.Lifecycle = Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleTemplateDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, it specifies the lifecycle configuration for the failure store of this data stream.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplateDescriptor Lifecycle(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleTemplateDescriptor>? action)
	{
		Instance.Lifecycle = Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleTemplateDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplate Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplateDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplateDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreTemplate(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}