// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

/// <summary>
/// <para>
/// Data stream failure store contains the configuration of the failure store for a given data stream.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.DataStreamFailureStoreConverter))]
public sealed partial class DataStreamFailureStore
{
#if NET7_0_OR_GREATER
	public DataStreamFailureStore()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public DataStreamFailureStore()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DataStreamFailureStore(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If defined, it turns the failure store on/off (<c>true</c>/<c>false</c>) for this data stream. A data stream failure store
	/// that's disabled (enabled: <c>false</c>) will redirect no new failed indices to the failure store; however, it will
	/// not remove any existing data from the failure store.
	/// </para>
	/// </summary>
	public bool? Enabled { get; set; }

	/// <summary>
	/// <para>
	/// If defined, it specifies the lifecycle configuration for the failure store of this data stream.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycle? Lifecycle { get; set; }
}

/// <summary>
/// <para>
/// Data stream failure store contains the configuration of the failure store for a given data stream.
/// </para>
/// </summary>
public readonly partial struct DataStreamFailureStoreDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStore Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataStreamFailureStoreDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStore instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataStreamFailureStoreDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStore(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStore instance) => new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStore(Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// If defined, it turns the failure store on/off (<c>true</c>/<c>false</c>) for this data stream. A data stream failure store
	/// that's disabled (enabled: <c>false</c>) will redirect no new failed indices to the failure store; however, it will
	/// not remove any existing data from the failure store.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreDescriptor Enabled(bool? value = true)
	{
		Instance.Enabled = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, it specifies the lifecycle configuration for the failure store of this data stream.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreDescriptor Lifecycle(Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycle? value)
	{
		Instance.Lifecycle = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, it specifies the lifecycle configuration for the failure store of this data stream.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreDescriptor Lifecycle()
	{
		Instance.Lifecycle = Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleDescriptor.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// If defined, it specifies the lifecycle configuration for the failure store of this data stream.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreDescriptor Lifecycle(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleDescriptor>? action)
	{
		Instance.Lifecycle = Elastic.Clients.Elasticsearch.IndexManagement.FailureStoreLifecycleDescriptor.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStore Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStore(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStoreDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.DataStreamFailureStore(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}