// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.DataStreamConverter))]
public sealed partial class DataStream
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DataStream(int generation, bool hidden, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamIndex> indices, string name, Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy nextGenerationManagedBy, bool preferIlm, bool rolloverOnWrite, Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings settings, Elastic.Clients.Elasticsearch.HealthStatus status, string template, Elastic.Clients.Elasticsearch.IndexManagement.DataStreamTimestampField timestampField)
	{
		Generation = generation;
		Hidden = hidden;
		Indices = indices;
		Name = name;
		NextGenerationManagedBy = nextGenerationManagedBy;
		PreferIlm = preferIlm;
		RolloverOnWrite = rolloverOnWrite;
		Settings = settings;
		Status = status;
		Template = template;
		TimestampField = timestampField;
	}
#if NET7_0_OR_GREATER
	public DataStream()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DataStream()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DataStream(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the data stream allows custom routing on write request.
	/// </para>
	/// </summary>
	public bool? AllowCustomRouting { get; set; }

	/// <summary>
	/// <para>
	/// Information about failure store backing indices
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.FailureStore? FailureStore { get; set; }

	/// <summary>
	/// <para>
	/// Current generation for the data stream. This number acts as a cumulative count of the stream’s rollovers, starting at 1.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int Generation { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the data stream is hidden.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool Hidden { get; set; }

	/// <summary>
	/// <para>
	/// Name of the current ILM lifecycle policy in the stream’s matching index template.
	/// This lifecycle policy is set in the <c>index.lifecycle.name</c> setting.
	/// If the template does not include a lifecycle policy, this property is not included in the response.
	/// NOTE: A data stream’s backing indices may be assigned different lifecycle policies. To retrieve the lifecycle policy for individual backing indices, use the get index settings API.
	/// </para>
	/// </summary>
	public string? IlmPolicy { get; set; }

	/// <summary>
	/// <para>
	/// The index mode for the data stream that will be used for newly created backing indices.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.IndexMode? IndexMode { get; set; }

	/// <summary>
	/// <para>
	/// Array of objects containing information about the data stream’s backing indices.
	/// The last item in this array contains information about the stream’s current write index.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.IndexManagement.DataStreamIndex> Indices { get; set; }

	/// <summary>
	/// <para>
	/// Contains the configuration for the data stream lifecycle of this data stream.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.DataStreamLifecycleWithRollover? Lifecycle { get; set; }

	/// <summary>
	/// <para>
	/// Custom metadata for the stream, copied from the <c>_meta</c> object of the stream’s matching index template.
	/// If empty, the response omits this property.
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyDictionary<string, object>? Meta { get; set; }

	/// <summary>
	/// <para>
	/// Name of the data stream.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Name { get; set; }

	/// <summary>
	/// <para>
	/// Name of the lifecycle system that'll manage the next generation of the data stream.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexManagement.ManagedBy NextGenerationManagedBy { get; set; }

	/// <summary>
	/// <para>
	/// Indicates if ILM should take precedence over DSL in case both are configured to managed this data stream.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool PreferIlm { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the data stream is created and managed by cross-cluster replication and the local cluster can not write into this data stream or change its mappings.
	/// </para>
	/// </summary>
	public bool? Replicated { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the next write to this data stream will trigger a rollover first and the document will be indexed in the new backing index. If the rollover fails the indexing request will fail too.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool RolloverOnWrite { get; set; }

	/// <summary>
	/// <para>
	/// The settings specific to this data stream that will take precedence over the settings in the matching index
	/// template.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings Settings { get; set; }

	/// <summary>
	/// <para>
	/// Health status of the data stream.
	/// This health status is based on the state of the primary and replica shards of the stream’s backing indices.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.HealthStatus Status { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the data stream is created and managed by an Elastic stack component and cannot be modified through normal user interaction.
	/// </para>
	/// </summary>
	public bool? System { get; set; }

	/// <summary>
	/// <para>
	/// Name of the index template used to create the data stream’s backing indices.
	/// The template’s index pattern must match the name of this data stream.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Template { get; set; }

	/// <summary>
	/// <para>
	/// Information about the <c>@timestamp</c> field in the data stream.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.IndexManagement.DataStreamTimestampField TimestampField { get; set; }
}