// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement.Json;

public sealed partial class CreateFromConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexManagement.CreateFrom>
{
	private static readonly System.Text.Json.JsonEncodedText PropMappingsOverride = System.Text.Json.JsonEncodedText.Encode("mappings_override");
	private static readonly System.Text.Json.JsonEncodedText PropRemoveIndexBlocks = System.Text.Json.JsonEncodedText.Encode("remove_index_blocks");
	private static readonly System.Text.Json.JsonEncodedText PropSettingsOverride = System.Text.Json.JsonEncodedText.Encode("settings_override");

	public override Elastic.Clients.Elasticsearch.IndexManagement.CreateFrom Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.Mapping.TypeMapping?> propMappingsOverride = default;
		LocalJsonValue<bool?> propRemoveIndexBlocks = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.IndexManagement.IndexSettings?> propSettingsOverride = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propMappingsOverride.TryReadProperty(ref reader, options, PropMappingsOverride, null))
			{
				continue;
			}

			if (propRemoveIndexBlocks.TryReadProperty(ref reader, options, PropRemoveIndexBlocks, static bool? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<bool>(o)))
			{
				continue;
			}

			if (propSettingsOverride.TryReadProperty(ref reader, options, PropSettingsOverride, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.IndexManagement.CreateFrom(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			MappingsOverride = propMappingsOverride.Value,
			RemoveIndexBlocks = propRemoveIndexBlocks.Value,
			SettingsOverride = propSettingsOverride.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexManagement.CreateFrom value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropMappingsOverride, value.MappingsOverride, null, null);
		writer.WriteProperty(options, PropRemoveIndexBlocks, value.RemoveIndexBlocks, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, bool? v) => w.WriteNullableValue<bool>(o, v));
		writer.WriteProperty(options, PropSettingsOverride, value.SettingsOverride, null, null);
		writer.WriteEndObject();
	}
}