// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.AliasConverter))]
public sealed partial class Alias
{
#if NET7_0_OR_GREATER
	public Alias()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public Alias()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Alias(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Query used to limit documents the alias can access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Query? Filter { get; set; }

	/// <summary>
	/// <para>
	/// Value used to route indexing operations to a specific shard.
	/// If specified, this overwrites the <c>routing</c> value for indexing operations.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Routing? IndexRouting { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the alias is hidden.
	/// All indices for the alias must have the same <c>is_hidden</c> value.
	/// </para>
	/// </summary>
	public bool? IsHidden { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the index is the write index for the alias.
	/// </para>
	/// </summary>
	public bool? IsWriteIndex { get; set; }

	/// <summary>
	/// <para>
	/// Value used to route indexing and search operations to a specific shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Routing? Routing { get; set; }

	/// <summary>
	/// <para>
	/// Value used to route search operations to a specific shard.
	/// If specified, this overwrites the <c>routing</c> value for search operations.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Routing? SearchRouting { get; set; }
}

public readonly partial struct AliasDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.Alias Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AliasDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.Alias instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AliasDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.Alias(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument>(Elastic.Clients.Elasticsearch.IndexManagement.Alias instance) => new Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.Alias(Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Query used to limit documents the alias can access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument> Filter(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query used to limit documents the alias can access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument> Filter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Value used to route indexing operations to a specific shard.
	/// If specified, this overwrites the <c>routing</c> value for indexing operations.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument> IndexRouting(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.IndexRouting = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the alias is hidden.
	/// All indices for the alias must have the same <c>is_hidden</c> value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument> IsHidden(bool? value = true)
	{
		Instance.IsHidden = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the index is the write index for the alias.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument> IsWriteIndex(bool? value = true)
	{
		Instance.IsWriteIndex = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Value used to route indexing and search operations to a specific shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument> Routing(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.Routing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Value used to route search operations to a specific shard.
	/// If specified, this overwrites the <c>routing</c> value for search operations.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument> SearchRouting(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.SearchRouting = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.Alias Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.Alias(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.IndexManagement.Alias(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct AliasDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.Alias Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AliasDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.Alias instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AliasDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.Alias(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.Alias instance) => new Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.Alias(Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Query used to limit documents the alias can access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor Filter(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query used to limit documents the alias can access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor Filter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Query used to limit documents the alias can access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor Filter<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Value used to route indexing operations to a specific shard.
	/// If specified, this overwrites the <c>routing</c> value for indexing operations.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor IndexRouting(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.IndexRouting = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the alias is hidden.
	/// All indices for the alias must have the same <c>is_hidden</c> value.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor IsHidden(bool? value = true)
	{
		Instance.IsHidden = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the index is the write index for the alias.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor IsWriteIndex(bool? value = true)
	{
		Instance.IsWriteIndex = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Value used to route indexing and search operations to a specific shard.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor Routing(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.Routing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Value used to route search operations to a specific shard.
	/// If specified, this overwrites the <c>routing</c> value for search operations.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor SearchRouting(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.SearchRouting = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.Alias Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.Alias(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.AliasDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.Alias(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}