// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexManagement.Json.AddActionConverter))]
public sealed partial class AddAction
{
#if NET7_0_OR_GREATER
	public AddAction()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public AddAction()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AddAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Alias for the action.
	/// Index alias names support date math.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexAlias? Alias { get; set; }

	/// <summary>
	/// <para>
	/// Aliases for the action.
	/// Index alias names support date math.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.IndexAlias>? Aliases { get; set; }

	/// <summary>
	/// <para>
	/// Query used to limit documents the alias can access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.QueryDsl.Query? Filter { get; set; }

	/// <summary>
	/// <para>
	/// Data stream or index for the action.
	/// Supports wildcards (<c>*</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexName? Index { get; set; }

	/// <summary>
	/// <para>
	/// Value used to route indexing operations to a specific shard.
	/// If specified, this overwrites the <c>routing</c> value for indexing operations.
	/// Data stream aliases don’t support this parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Routing? IndexRouting { get; set; }

	/// <summary>
	/// <para>
	/// Data streams or indices for the action.
	/// Supports wildcards (<c>*</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Indices? Indices { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the alias is hidden.
	/// </para>
	/// </summary>
	public bool? IsHidden { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, sets the write index or data stream for the alias.
	/// </para>
	/// </summary>
	public bool? IsWriteIndex { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, the alias must exist to perform the action.
	/// </para>
	/// </summary>
	public bool? MustExist { get; set; }

	/// <summary>
	/// <para>
	/// Value used to route indexing and search operations to a specific shard.
	/// Data stream aliases don’t support this parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Routing? Routing { get; set; }

	/// <summary>
	/// <para>
	/// Value used to route search operations to a specific shard.
	/// If specified, this overwrites the <c>routing</c> value for search operations.
	/// Data stream aliases don’t support this parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Routing? SearchRouting { get; set; }
}

public readonly partial struct AddActionDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.AddAction Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AddActionDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.AddAction instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AddActionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.AddAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument>(Elastic.Clients.Elasticsearch.IndexManagement.AddAction instance) => new Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.AddAction(Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Alias for the action.
	/// Index alias names support date math.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument> Alias(Elastic.Clients.Elasticsearch.IndexAlias? value)
	{
		Instance.Alias = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the action.
	/// Index alias names support date math.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument> Aliases(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.IndexAlias>? value)
	{
		Instance.Aliases = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the action.
	/// Index alias names support date math.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument> Aliases(params Elastic.Clients.Elasticsearch.IndexAlias[] values)
	{
		Instance.Aliases = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Query used to limit documents the alias can access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument> Filter(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query used to limit documents the alias can access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument> Filter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Data stream or index for the action.
	/// Supports wildcards (<c>*</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument> Index(Elastic.Clients.Elasticsearch.IndexName? value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Value used to route indexing operations to a specific shard.
	/// If specified, this overwrites the <c>routing</c> value for indexing operations.
	/// Data stream aliases don’t support this parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument> IndexRouting(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.IndexRouting = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Data streams or indices for the action.
	/// Supports wildcards (<c>*</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument> Indices(Elastic.Clients.Elasticsearch.Indices? value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the alias is hidden.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument> IsHidden(bool? value = true)
	{
		Instance.IsHidden = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, sets the write index or data stream for the alias.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument> IsWriteIndex(bool? value = true)
	{
		Instance.IsWriteIndex = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the alias must exist to perform the action.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument> MustExist(bool? value = true)
	{
		Instance.MustExist = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Value used to route indexing and search operations to a specific shard.
	/// Data stream aliases don’t support this parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument> Routing(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.Routing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Value used to route search operations to a specific shard.
	/// If specified, this overwrites the <c>routing</c> value for search operations.
	/// Data stream aliases don’t support this parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument> SearchRouting(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.SearchRouting = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.AddAction Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.AddAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.IndexManagement.AddAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct AddActionDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexManagement.AddAction Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AddActionDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.AddAction instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AddActionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexManagement.AddAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor(Elastic.Clients.Elasticsearch.IndexManagement.AddAction instance) => new Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexManagement.AddAction(Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Alias for the action.
	/// Index alias names support date math.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor Alias(Elastic.Clients.Elasticsearch.IndexAlias? value)
	{
		Instance.Alias = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the action.
	/// Index alias names support date math.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor Aliases(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.IndexAlias>? value)
	{
		Instance.Aliases = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Aliases for the action.
	/// Index alias names support date math.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor Aliases(params Elastic.Clients.Elasticsearch.IndexAlias[] values)
	{
		Instance.Aliases = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Query used to limit documents the alias can access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor Filter(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Filter = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Query used to limit documents the alias can access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor Filter(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Query used to limit documents the alias can access.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor Filter<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Filter = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Data stream or index for the action.
	/// Supports wildcards (<c>*</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor Index(Elastic.Clients.Elasticsearch.IndexName? value)
	{
		Instance.Index = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Value used to route indexing operations to a specific shard.
	/// If specified, this overwrites the <c>routing</c> value for indexing operations.
	/// Data stream aliases don’t support this parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor IndexRouting(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.IndexRouting = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Data streams or indices for the action.
	/// Supports wildcards (<c>*</c>).
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor Indices(Elastic.Clients.Elasticsearch.Indices? value)
	{
		Instance.Indices = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the alias is hidden.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor IsHidden(bool? value = true)
	{
		Instance.IsHidden = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, sets the write index or data stream for the alias.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor IsWriteIndex(bool? value = true)
	{
		Instance.IsWriteIndex = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, the alias must exist to perform the action.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor MustExist(bool? value = true)
	{
		Instance.MustExist = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Value used to route indexing and search operations to a specific shard.
	/// Data stream aliases don’t support this parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor Routing(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.Routing = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Value used to route search operations to a specific shard.
	/// If specified, this overwrites the <c>routing</c> value for search operations.
	/// Data stream aliases don’t support this parameter.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor SearchRouting(Elastic.Clients.Elasticsearch.Routing? value)
	{
		Instance.SearchRouting = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexManagement.AddAction Build(System.Action<Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexManagement.AddAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexManagement.AddActionDescriptor(new Elastic.Clients.Elasticsearch.IndexManagement.AddAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}