// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexLifecycleManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexLifecycleManagement.Json.StepKeyConverter))]
public sealed partial class StepKey
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public StepKey(string phase)
	{
		Phase = phase;
	}
#if NET7_0_OR_GREATER
	public StepKey()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public StepKey()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal StepKey(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The optional action to which the index will be moved.
	/// </para>
	/// </summary>
	public string? Action { get; set; }

	/// <summary>
	/// <para>
	/// The optional step name to which the index will be moved.
	/// </para>
	/// </summary>
	public string? Name { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Phase { get; set; }
}

public readonly partial struct StepKeyDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexLifecycleManagement.StepKey Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public StepKeyDescriptor(Elastic.Clients.Elasticsearch.IndexLifecycleManagement.StepKey instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public StepKeyDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexLifecycleManagement.StepKey(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexLifecycleManagement.StepKeyDescriptor(Elastic.Clients.Elasticsearch.IndexLifecycleManagement.StepKey instance) => new Elastic.Clients.Elasticsearch.IndexLifecycleManagement.StepKeyDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexLifecycleManagement.StepKey(Elastic.Clients.Elasticsearch.IndexLifecycleManagement.StepKeyDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The optional action to which the index will be moved.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.StepKeyDescriptor Action(string? value)
	{
		Instance.Action = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The optional step name to which the index will be moved.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.StepKeyDescriptor Name(string? value)
	{
		Instance.Name = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.StepKeyDescriptor Phase(string value)
	{
		Instance.Phase = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexLifecycleManagement.StepKey Build(System.Action<Elastic.Clients.Elasticsearch.IndexLifecycleManagement.StepKeyDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.IndexLifecycleManagement.StepKeyDescriptor(new Elastic.Clients.Elasticsearch.IndexLifecycleManagement.StepKey(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}