// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexLifecycleManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexLifecycleManagement.Json.ShrinkActionConverter))]
public sealed partial class ShrinkAction
{
#if NET7_0_OR_GREATER
	public ShrinkAction()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public ShrinkAction()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ShrinkAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public bool? AllowWriteAfterShrink { get; set; }
	public Elastic.Clients.Elasticsearch.ByteSize? MaxPrimaryShardSize { get; set; }
	public int? NumberOfShards { get; set; }
}

public readonly partial struct ShrinkActionDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexLifecycleManagement.ShrinkAction Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ShrinkActionDescriptor(Elastic.Clients.Elasticsearch.IndexLifecycleManagement.ShrinkAction instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ShrinkActionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexLifecycleManagement.ShrinkAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexLifecycleManagement.ShrinkActionDescriptor(Elastic.Clients.Elasticsearch.IndexLifecycleManagement.ShrinkAction instance) => new Elastic.Clients.Elasticsearch.IndexLifecycleManagement.ShrinkActionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexLifecycleManagement.ShrinkAction(Elastic.Clients.Elasticsearch.IndexLifecycleManagement.ShrinkActionDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.ShrinkActionDescriptor AllowWriteAfterShrink(bool? value = true)
	{
		Instance.AllowWriteAfterShrink = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.ShrinkActionDescriptor MaxPrimaryShardSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MaxPrimaryShardSize = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.ShrinkActionDescriptor MaxPrimaryShardSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MaxPrimaryShardSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.ShrinkActionDescriptor NumberOfShards(int? value)
	{
		Instance.NumberOfShards = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexLifecycleManagement.ShrinkAction Build(System.Action<Elastic.Clients.Elasticsearch.IndexLifecycleManagement.ShrinkActionDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexLifecycleManagement.ShrinkAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexLifecycleManagement.ShrinkActionDescriptor(new Elastic.Clients.Elasticsearch.IndexLifecycleManagement.ShrinkAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}