// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexLifecycleManagement;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.IndexLifecycleManagement.Json.RolloverActionConverter))]
public sealed partial class RolloverAction
{
#if NET7_0_OR_GREATER
	public RolloverAction()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public RolloverAction()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal RolloverAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.Duration? MaxAge { get; set; }
	public long? MaxDocs { get; set; }
	public long? MaxPrimaryShardDocs { get; set; }
	public Elastic.Clients.Elasticsearch.ByteSize? MaxPrimaryShardSize { get; set; }
	public Elastic.Clients.Elasticsearch.ByteSize? MaxSize { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? MinAge { get; set; }
	public long? MinDocs { get; set; }
	public long? MinPrimaryShardDocs { get; set; }
	public Elastic.Clients.Elasticsearch.ByteSize? MinPrimaryShardSize { get; set; }
	public Elastic.Clients.Elasticsearch.ByteSize? MinSize { get; set; }
}

public readonly partial struct RolloverActionDescriptor
{
	internal Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverAction Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RolloverActionDescriptor(Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverAction instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public RolloverActionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverActionDescriptor(Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverAction instance) => new Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverActionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverAction(Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverActionDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverActionDescriptor MaxAge(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MaxAge = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverActionDescriptor MaxDocs(long? value)
	{
		Instance.MaxDocs = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverActionDescriptor MaxPrimaryShardDocs(long? value)
	{
		Instance.MaxPrimaryShardDocs = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverActionDescriptor MaxPrimaryShardSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MaxPrimaryShardSize = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverActionDescriptor MaxPrimaryShardSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MaxPrimaryShardSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverActionDescriptor MaxSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MaxSize = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverActionDescriptor MaxSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MaxSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverActionDescriptor MinAge(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.MinAge = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverActionDescriptor MinDocs(long? value)
	{
		Instance.MinDocs = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverActionDescriptor MinPrimaryShardDocs(long? value)
	{
		Instance.MinPrimaryShardDocs = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverActionDescriptor MinPrimaryShardSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MinPrimaryShardSize = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverActionDescriptor MinPrimaryShardSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MinPrimaryShardSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverActionDescriptor MinSize(Elastic.Clients.Elasticsearch.ByteSize? value)
	{
		Instance.MinSize = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverActionDescriptor MinSize(System.Func<Elastic.Clients.Elasticsearch.ByteSizeFactory, Elastic.Clients.Elasticsearch.ByteSize> action)
	{
		Instance.MinSize = Elastic.Clients.Elasticsearch.ByteSizeFactory.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverAction Build(System.Action<Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverActionDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverActionDescriptor(new Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}