// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.IndexLifecycleManagement.Json;

public sealed partial class RolloverActionConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverAction>
{
	private static readonly System.Text.Json.JsonEncodedText PropMaxAge = System.Text.Json.JsonEncodedText.Encode("max_age");
	private static readonly System.Text.Json.JsonEncodedText PropMaxDocs = System.Text.Json.JsonEncodedText.Encode("max_docs");
	private static readonly System.Text.Json.JsonEncodedText PropMaxPrimaryShardDocs = System.Text.Json.JsonEncodedText.Encode("max_primary_shard_docs");
	private static readonly System.Text.Json.JsonEncodedText PropMaxPrimaryShardSize = System.Text.Json.JsonEncodedText.Encode("max_primary_shard_size");
	private static readonly System.Text.Json.JsonEncodedText PropMaxSize = System.Text.Json.JsonEncodedText.Encode("max_size");
	private static readonly System.Text.Json.JsonEncodedText PropMinAge = System.Text.Json.JsonEncodedText.Encode("min_age");
	private static readonly System.Text.Json.JsonEncodedText PropMinDocs = System.Text.Json.JsonEncodedText.Encode("min_docs");
	private static readonly System.Text.Json.JsonEncodedText PropMinPrimaryShardDocs = System.Text.Json.JsonEncodedText.Encode("min_primary_shard_docs");
	private static readonly System.Text.Json.JsonEncodedText PropMinPrimaryShardSize = System.Text.Json.JsonEncodedText.Encode("min_primary_shard_size");
	private static readonly System.Text.Json.JsonEncodedText PropMinSize = System.Text.Json.JsonEncodedText.Encode("min_size");

	public override Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverAction Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propMaxAge = default;
		LocalJsonValue<long?> propMaxDocs = default;
		LocalJsonValue<long?> propMaxPrimaryShardDocs = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propMaxPrimaryShardSize = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propMaxSize = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propMinAge = default;
		LocalJsonValue<long?> propMinDocs = default;
		LocalJsonValue<long?> propMinPrimaryShardDocs = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propMinPrimaryShardSize = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize?> propMinSize = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propMaxAge.TryReadProperty(ref reader, options, PropMaxAge, null))
			{
				continue;
			}

			if (propMaxDocs.TryReadProperty(ref reader, options, PropMaxDocs, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propMaxPrimaryShardDocs.TryReadProperty(ref reader, options, PropMaxPrimaryShardDocs, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propMaxPrimaryShardSize.TryReadProperty(ref reader, options, PropMaxPrimaryShardSize, null))
			{
				continue;
			}

			if (propMaxSize.TryReadProperty(ref reader, options, PropMaxSize, null))
			{
				continue;
			}

			if (propMinAge.TryReadProperty(ref reader, options, PropMinAge, null))
			{
				continue;
			}

			if (propMinDocs.TryReadProperty(ref reader, options, PropMinDocs, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propMinPrimaryShardDocs.TryReadProperty(ref reader, options, PropMinPrimaryShardDocs, static long? (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadNullableValue<long>(o)))
			{
				continue;
			}

			if (propMinPrimaryShardSize.TryReadProperty(ref reader, options, PropMinPrimaryShardSize, null))
			{
				continue;
			}

			if (propMinSize.TryReadProperty(ref reader, options, PropMinSize, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverAction(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			MaxAge = propMaxAge.Value,
			MaxDocs = propMaxDocs.Value,
			MaxPrimaryShardDocs = propMaxPrimaryShardDocs.Value,
			MaxPrimaryShardSize = propMaxPrimaryShardSize.Value,
			MaxSize = propMaxSize.Value,
			MinAge = propMinAge.Value,
			MinDocs = propMinDocs.Value,
			MinPrimaryShardDocs = propMinPrimaryShardDocs.Value,
			MinPrimaryShardSize = propMinPrimaryShardSize.Value,
			MinSize = propMinSize.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IndexLifecycleManagement.RolloverAction value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropMaxAge, value.MaxAge, null, null);
		writer.WriteProperty(options, PropMaxDocs, value.MaxDocs, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropMaxPrimaryShardDocs, value.MaxPrimaryShardDocs, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropMaxPrimaryShardSize, value.MaxPrimaryShardSize, null, null);
		writer.WriteProperty(options, PropMaxSize, value.MaxSize, null, null);
		writer.WriteProperty(options, PropMinAge, value.MinAge, null, null);
		writer.WriteProperty(options, PropMinDocs, value.MinDocs, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropMinPrimaryShardDocs, value.MinPrimaryShardDocs, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, long? v) => w.WriteNullableValue<long>(o, v));
		writer.WriteProperty(options, PropMinPrimaryShardSize, value.MinPrimaryShardSize, null, null);
		writer.WriteProperty(options, PropMinSize, value.MinSize, null, null);
		writer.WriteEndObject();
	}
}