// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class IBLambdaConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IBLambda>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDf = System.Text.Json.JsonEncodedText.Encode("df");
	private static readonly System.Text.Json.JsonEncodedText MemberTtf = System.Text.Json.JsonEncodedText.Encode("ttf");

	public override Elastic.Clients.Elasticsearch.IBLambda Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDf))
		{
			return Elastic.Clients.Elasticsearch.IBLambda.Df;
		}

		if (reader.ValueTextEquals(MemberTtf))
		{
			return Elastic.Clients.Elasticsearch.IBLambda.Ttf;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDf.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IBLambda.Df;
		}

		if (string.Equals(value, MemberTtf.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IBLambda.Ttf;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IBLambda)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IBLambda value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.IBLambda.Df:
				writer.WriteStringValue(MemberDf);
				break;
			case Elastic.Clients.Elasticsearch.IBLambda.Ttf:
				writer.WriteStringValue(MemberTtf);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IBLambda)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.IBLambda ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IBLambda value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}