// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class IBDistributionConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.IBDistribution>
{
	private static readonly System.Text.Json.JsonEncodedText MemberLl = System.Text.Json.JsonEncodedText.Encode("ll");
	private static readonly System.Text.Json.JsonEncodedText MemberSpl = System.Text.Json.JsonEncodedText.Encode("spl");

	public override Elastic.Clients.Elasticsearch.IBDistribution Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberLl))
		{
			return Elastic.Clients.Elasticsearch.IBDistribution.Ll;
		}

		if (reader.ValueTextEquals(MemberSpl))
		{
			return Elastic.Clients.Elasticsearch.IBDistribution.Spl;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberLl.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IBDistribution.Ll;
		}

		if (string.Equals(value, MemberSpl.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.IBDistribution.Spl;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IBDistribution)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IBDistribution value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.IBDistribution.Ll:
				writer.WriteStringValue(MemberLl);
				break;
			case Elastic.Clients.Elasticsearch.IBDistribution.Spl:
				writer.WriteStringValue(MemberSpl);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.IBDistribution)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.IBDistribution ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.IBDistribution value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}