// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.HealthStatusConverter))]
public enum HealthStatus
{
	/// <summary>
	/// <para>
	/// All shards are assigned.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "green")]
	Green,
	/// <summary>
	/// <para>
	/// One or more primary shards are unassigned, so some data is unavailable. This can occur briefly during cluster startup as primary shards are assigned.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "red")]
	Red,
	[System.Runtime.Serialization.EnumMember(Value = "unavailable")]
	Unavailable,
	[System.Runtime.Serialization.EnumMember(Value = "unknown")]
	Unknown,
	/// <summary>
	/// <para>
	/// All primary shards are assigned, but one or more replica shards are unassigned. If a node in the cluster fails, some data could be unavailable until that node is repaired.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "yellow")]
	Yellow
}