// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class HealthStatusConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.HealthStatus>
{
	private static readonly System.Text.Json.JsonEncodedText MemberGreen = System.Text.Json.JsonEncodedText.Encode("green");
	private static readonly System.Text.Json.JsonEncodedText MemberGreen1 = System.Text.Json.JsonEncodedText.Encode("GREEN");
	private static readonly System.Text.Json.JsonEncodedText MemberRed = System.Text.Json.JsonEncodedText.Encode("red");
	private static readonly System.Text.Json.JsonEncodedText MemberRed1 = System.Text.Json.JsonEncodedText.Encode("RED");
	private static readonly System.Text.Json.JsonEncodedText MemberUnavailable = System.Text.Json.JsonEncodedText.Encode("unavailable");
	private static readonly System.Text.Json.JsonEncodedText MemberUnknown = System.Text.Json.JsonEncodedText.Encode("unknown");
	private static readonly System.Text.Json.JsonEncodedText MemberYellow = System.Text.Json.JsonEncodedText.Encode("yellow");
	private static readonly System.Text.Json.JsonEncodedText MemberYellow1 = System.Text.Json.JsonEncodedText.Encode("YELLOW");

	public override Elastic.Clients.Elasticsearch.HealthStatus Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberGreen) || reader.ValueTextEquals(MemberGreen1))
		{
			return Elastic.Clients.Elasticsearch.HealthStatus.Green;
		}

		if (reader.ValueTextEquals(MemberRed) || reader.ValueTextEquals(MemberRed1))
		{
			return Elastic.Clients.Elasticsearch.HealthStatus.Red;
		}

		if (reader.ValueTextEquals(MemberUnavailable))
		{
			return Elastic.Clients.Elasticsearch.HealthStatus.Unavailable;
		}

		if (reader.ValueTextEquals(MemberUnknown))
		{
			return Elastic.Clients.Elasticsearch.HealthStatus.Unknown;
		}

		if (reader.ValueTextEquals(MemberYellow) || reader.ValueTextEquals(MemberYellow1))
		{
			return Elastic.Clients.Elasticsearch.HealthStatus.Yellow;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberGreen.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberGreen1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.HealthStatus.Green;
		}

		if (string.Equals(value, MemberRed.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberRed1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.HealthStatus.Red;
		}

		if (string.Equals(value, MemberUnavailable.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.HealthStatus.Unavailable;
		}

		if (string.Equals(value, MemberUnknown.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.HealthStatus.Unknown;
		}

		if (string.Equals(value, MemberYellow.Value, System.StringComparison.OrdinalIgnoreCase) || string.Equals(value, MemberYellow1.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.HealthStatus.Yellow;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.HealthStatus)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.HealthStatus value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.HealthStatus.Green:
				writer.WriteStringValue(MemberGreen);
				break;
			case Elastic.Clients.Elasticsearch.HealthStatus.Red:
				writer.WriteStringValue(MemberRed);
				break;
			case Elastic.Clients.Elasticsearch.HealthStatus.Unavailable:
				writer.WriteStringValue(MemberUnavailable);
				break;
			case Elastic.Clients.Elasticsearch.HealthStatus.Unknown:
				writer.WriteStringValue(MemberUnknown);
				break;
			case Elastic.Clients.Elasticsearch.HealthStatus.Yellow:
				writer.WriteStringValue(MemberYellow);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.HealthStatus)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.HealthStatus ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.HealthStatus value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}