// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Graph;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Graph.Json.VertexDefinitionConverter))]
public sealed partial class VertexDefinition
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public VertexDefinition(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public VertexDefinition()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public VertexDefinition()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal VertexDefinition(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Prevents the specified terms from being included in the results.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<string>? Exclude { get; set; }

	/// <summary>
	/// <para>
	/// Identifies a field in the documents of interest.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }

	/// <summary>
	/// <para>
	/// Identifies the terms of interest that form the starting points from which you want to spider out.
	/// </para>
	/// </summary>
	public System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Graph.VertexInclude>? Include { get; set; }

	/// <summary>
	/// <para>
	/// Specifies how many documents must contain a pair of terms before it is considered to be a useful connection.
	/// This setting acts as a certainty threshold.
	/// </para>
	/// </summary>
	public long? MinDocCount { get; set; }

	/// <summary>
	/// <para>
	/// Controls how many documents on a particular shard have to contain a pair of terms before the connection is returned for global consideration.
	/// </para>
	/// </summary>
	public long? ShardMinDocCount { get; set; }

	/// <summary>
	/// <para>
	/// Specifies the maximum number of vertex terms returned for each field.
	/// </para>
	/// </summary>
	public int? Size { get; set; }
}

public readonly partial struct VertexDefinitionDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Graph.VertexDefinition Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public VertexDefinitionDescriptor(Elastic.Clients.Elasticsearch.Graph.VertexDefinition instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public VertexDefinitionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Graph.VertexDefinition(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Graph.VertexDefinition instance) => new Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Graph.VertexDefinition(Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Prevents the specified terms from being included in the results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor<TDocument> Exclude(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Exclude = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Prevents the specified terms from being included in the results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor<TDocument> Exclude(params string[] values)
	{
		Instance.Exclude = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifies a field in the documents of interest.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifies a field in the documents of interest.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifies the terms of interest that form the starting points from which you want to spider out.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor<TDocument> Include(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Graph.VertexInclude>? value)
	{
		Instance.Include = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifies the terms of interest that form the starting points from which you want to spider out.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor<TDocument> Include(params Elastic.Clients.Elasticsearch.Graph.VertexInclude[] values)
	{
		Instance.Include = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifies the terms of interest that form the starting points from which you want to spider out.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor<TDocument> Include(params System.Action<Elastic.Clients.Elasticsearch.Graph.VertexIncludeDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Graph.VertexInclude>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Graph.VertexIncludeDescriptor.Build(action));
		}

		Instance.Include = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies how many documents must contain a pair of terms before it is considered to be a useful connection.
	/// This setting acts as a certainty threshold.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor<TDocument> MinDocCount(long? value)
	{
		Instance.MinDocCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls how many documents on a particular shard have to contain a pair of terms before the connection is returned for global consideration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor<TDocument> ShardMinDocCount(long? value)
	{
		Instance.ShardMinDocCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the maximum number of vertex terms returned for each field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor<TDocument> Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Graph.VertexDefinition Build(System.Action<Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Graph.VertexDefinition(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct VertexDefinitionDescriptor
{
	internal Elastic.Clients.Elasticsearch.Graph.VertexDefinition Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public VertexDefinitionDescriptor(Elastic.Clients.Elasticsearch.Graph.VertexDefinition instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public VertexDefinitionDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Graph.VertexDefinition(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor(Elastic.Clients.Elasticsearch.Graph.VertexDefinition instance) => new Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Graph.VertexDefinition(Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Prevents the specified terms from being included in the results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor Exclude(System.Collections.Generic.ICollection<string>? value)
	{
		Instance.Exclude = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Prevents the specified terms from being included in the results.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor Exclude(params string[] values)
	{
		Instance.Exclude = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifies a field in the documents of interest.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifies a field in the documents of interest.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifies the terms of interest that form the starting points from which you want to spider out.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor Include(System.Collections.Generic.ICollection<Elastic.Clients.Elasticsearch.Graph.VertexInclude>? value)
	{
		Instance.Include = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifies the terms of interest that form the starting points from which you want to spider out.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor Include(params Elastic.Clients.Elasticsearch.Graph.VertexInclude[] values)
	{
		Instance.Include = [.. values];
		return this;
	}

	/// <summary>
	/// <para>
	/// Identifies the terms of interest that form the starting points from which you want to spider out.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor Include(params System.Action<Elastic.Clients.Elasticsearch.Graph.VertexIncludeDescriptor>[] actions)
	{
		var items = new System.Collections.Generic.List<Elastic.Clients.Elasticsearch.Graph.VertexInclude>();
		foreach (var action in actions)
		{
			items.Add(Elastic.Clients.Elasticsearch.Graph.VertexIncludeDescriptor.Build(action));
		}

		Instance.Include = items;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies how many documents must contain a pair of terms before it is considered to be a useful connection.
	/// This setting acts as a certainty threshold.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor MinDocCount(long? value)
	{
		Instance.MinDocCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Controls how many documents on a particular shard have to contain a pair of terms before the connection is returned for global consideration.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor ShardMinDocCount(long? value)
	{
		Instance.ShardMinDocCount = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Specifies the maximum number of vertex terms returned for each field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor Size(int? value)
	{
		Instance.Size = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Graph.VertexDefinition Build(System.Action<Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Graph.VertexDefinitionDescriptor(new Elastic.Clients.Elasticsearch.Graph.VertexDefinition(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}