// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Graph;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Graph.Json.ExploreControlsConverter))]
public sealed partial class ExploreControls
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ExploreControls(bool useSignificance)
	{
		UseSignificance = useSignificance;
	}
#if NET7_0_OR_GREATER
	public ExploreControls()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ExploreControls()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ExploreControls(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// To avoid the top-matching documents sample being dominated by a single source of results, it is sometimes necessary to request diversity in the sample.
	/// You can do this by selecting a single-value field and setting a maximum number of documents per value for that field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.SampleDiversity? SampleDiversity { get; set; }

	/// <summary>
	/// <para>
	/// Each hop considers a sample of the best-matching documents on each shard.
	/// Using samples improves the speed of execution and keeps exploration focused on meaningfully-connected terms.
	/// Very small values (less than 50) might not provide sufficient weight-of-evidence to identify significant connections between terms.
	/// Very large sample sizes can dilute the quality of the results and increase execution times.
	/// </para>
	/// </summary>
	public int? SampleSize { get; set; }

	/// <summary>
	/// <para>
	/// The length of time in milliseconds after which exploration will be halted and the results gathered so far are returned.
	/// This timeout is honored on a best-effort basis.
	/// Execution might overrun this timeout if, for example, a long pause is encountered while FieldData is loaded for a field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? Timeout { get; set; }

	/// <summary>
	/// <para>
	/// Filters associated terms so only those that are significantly associated with your query are included.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool UseSignificance { get; set; }
}

public readonly partial struct ExploreControlsDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Graph.ExploreControls Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ExploreControlsDescriptor(Elastic.Clients.Elasticsearch.Graph.ExploreControls instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ExploreControlsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Graph.ExploreControls(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Graph.ExploreControls instance) => new Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Graph.ExploreControls(Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// To avoid the top-matching documents sample being dominated by a single source of results, it is sometimes necessary to request diversity in the sample.
	/// You can do this by selecting a single-value field and setting a maximum number of documents per value for that field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor<TDocument> SampleDiversity(Elastic.Clients.Elasticsearch.Graph.SampleDiversity? value)
	{
		Instance.SampleDiversity = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// To avoid the top-matching documents sample being dominated by a single source of results, it is sometimes necessary to request diversity in the sample.
	/// You can do this by selecting a single-value field and setting a maximum number of documents per value for that field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor<TDocument> SampleDiversity(System.Action<Elastic.Clients.Elasticsearch.Graph.SampleDiversityDescriptor<TDocument>> action)
	{
		Instance.SampleDiversity = Elastic.Clients.Elasticsearch.Graph.SampleDiversityDescriptor<TDocument>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Each hop considers a sample of the best-matching documents on each shard.
	/// Using samples improves the speed of execution and keeps exploration focused on meaningfully-connected terms.
	/// Very small values (less than 50) might not provide sufficient weight-of-evidence to identify significant connections between terms.
	/// Very large sample sizes can dilute the quality of the results and increase execution times.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor<TDocument> SampleSize(int? value)
	{
		Instance.SampleSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The length of time in milliseconds after which exploration will be halted and the results gathered so far are returned.
	/// This timeout is honored on a best-effort basis.
	/// Execution might overrun this timeout if, for example, a long pause is encountered while FieldData is loaded for a field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor<TDocument> Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filters associated terms so only those that are significantly associated with your query are included.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor<TDocument> UseSignificance(bool value = true)
	{
		Instance.UseSignificance = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Graph.ExploreControls Build(System.Action<Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Graph.ExploreControls(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct ExploreControlsDescriptor
{
	internal Elastic.Clients.Elasticsearch.Graph.ExploreControls Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ExploreControlsDescriptor(Elastic.Clients.Elasticsearch.Graph.ExploreControls instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ExploreControlsDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Graph.ExploreControls(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor(Elastic.Clients.Elasticsearch.Graph.ExploreControls instance) => new Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Graph.ExploreControls(Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// To avoid the top-matching documents sample being dominated by a single source of results, it is sometimes necessary to request diversity in the sample.
	/// You can do this by selecting a single-value field and setting a maximum number of documents per value for that field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor SampleDiversity(Elastic.Clients.Elasticsearch.Graph.SampleDiversity? value)
	{
		Instance.SampleDiversity = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// To avoid the top-matching documents sample being dominated by a single source of results, it is sometimes necessary to request diversity in the sample.
	/// You can do this by selecting a single-value field and setting a maximum number of documents per value for that field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor SampleDiversity(System.Action<Elastic.Clients.Elasticsearch.Graph.SampleDiversityDescriptor> action)
	{
		Instance.SampleDiversity = Elastic.Clients.Elasticsearch.Graph.SampleDiversityDescriptor.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// To avoid the top-matching documents sample being dominated by a single source of results, it is sometimes necessary to request diversity in the sample.
	/// You can do this by selecting a single-value field and setting a maximum number of documents per value for that field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor SampleDiversity<T>(System.Action<Elastic.Clients.Elasticsearch.Graph.SampleDiversityDescriptor<T>> action)
	{
		Instance.SampleDiversity = Elastic.Clients.Elasticsearch.Graph.SampleDiversityDescriptor<T>.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Each hop considers a sample of the best-matching documents on each shard.
	/// Using samples improves the speed of execution and keeps exploration focused on meaningfully-connected terms.
	/// Very small values (less than 50) might not provide sufficient weight-of-evidence to identify significant connections between terms.
	/// Very large sample sizes can dilute the quality of the results and increase execution times.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor SampleSize(int? value)
	{
		Instance.SampleSize = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The length of time in milliseconds after which exploration will be halted and the results gathered so far are returned.
	/// This timeout is honored on a best-effort basis.
	/// Execution might overrun this timeout if, for example, a long pause is encountered while FieldData is loaded for a field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor Timeout(Elastic.Clients.Elasticsearch.Duration? value)
	{
		Instance.Timeout = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Filters associated terms so only those that are significantly associated with your query are included.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor UseSignificance(bool value = true)
	{
		Instance.UseSignificance = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Graph.ExploreControls Build(System.Action<Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Graph.ExploreControlsDescriptor(new Elastic.Clients.Elasticsearch.Graph.ExploreControls(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}