// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.GeoShapeRelationConverter))]
public enum GeoShapeRelation
{
	/// <summary>
	/// <para>
	/// Return all documents whose <c>geo_shape</c> or <c>geo_point</c> field contains the query geometry.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "contains")]
	Contains,
	/// <summary>
	/// <para>
	/// Return all documents whose <c>geo_shape</c> or <c>geo_point</c> field has nothing in common with the query geometry.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "disjoint")]
	Disjoint,
	/// <summary>
	/// <para>
	/// Return all documents whose <c>geo_shape</c> or <c>geo_point</c> field intersects the query geometry.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "intersects")]
	Intersects,
	/// <summary>
	/// <para>
	/// Return all documents whose <c>geo_shape</c> or <c>geo_point</c> field is within the query geometry.
	/// Line geometries are not supported.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "within")]
	Within
}