// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class GeoShapeRelationConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.GeoShapeRelation>
{
	private static readonly System.Text.Json.JsonEncodedText MemberContains = System.Text.Json.JsonEncodedText.Encode("contains");
	private static readonly System.Text.Json.JsonEncodedText MemberDisjoint = System.Text.Json.JsonEncodedText.Encode("disjoint");
	private static readonly System.Text.Json.JsonEncodedText MemberIntersects = System.Text.Json.JsonEncodedText.Encode("intersects");
	private static readonly System.Text.Json.JsonEncodedText MemberWithin = System.Text.Json.JsonEncodedText.Encode("within");

	public override Elastic.Clients.Elasticsearch.GeoShapeRelation Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberContains))
		{
			return Elastic.Clients.Elasticsearch.GeoShapeRelation.Contains;
		}

		if (reader.ValueTextEquals(MemberDisjoint))
		{
			return Elastic.Clients.Elasticsearch.GeoShapeRelation.Disjoint;
		}

		if (reader.ValueTextEquals(MemberIntersects))
		{
			return Elastic.Clients.Elasticsearch.GeoShapeRelation.Intersects;
		}

		if (reader.ValueTextEquals(MemberWithin))
		{
			return Elastic.Clients.Elasticsearch.GeoShapeRelation.Within;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberContains.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.GeoShapeRelation.Contains;
		}

		if (string.Equals(value, MemberDisjoint.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.GeoShapeRelation.Disjoint;
		}

		if (string.Equals(value, MemberIntersects.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.GeoShapeRelation.Intersects;
		}

		if (string.Equals(value, MemberWithin.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.GeoShapeRelation.Within;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.GeoShapeRelation)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.GeoShapeRelation value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.GeoShapeRelation.Contains:
				writer.WriteStringValue(MemberContains);
				break;
			case Elastic.Clients.Elasticsearch.GeoShapeRelation.Disjoint:
				writer.WriteStringValue(MemberDisjoint);
				break;
			case Elastic.Clients.Elasticsearch.GeoShapeRelation.Intersects:
				writer.WriteStringValue(MemberIntersects);
				break;
			case Elastic.Clients.Elasticsearch.GeoShapeRelation.Within:
				writer.WriteStringValue(MemberWithin);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.GeoShapeRelation)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.GeoShapeRelation ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.GeoShapeRelation value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}