// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class GeoDistanceTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.GeoDistanceType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberArc = System.Text.Json.JsonEncodedText.Encode("arc");
	private static readonly System.Text.Json.JsonEncodedText MemberPlane = System.Text.Json.JsonEncodedText.Encode("plane");

	public override Elastic.Clients.Elasticsearch.GeoDistanceType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberArc))
		{
			return Elastic.Clients.Elasticsearch.GeoDistanceType.Arc;
		}

		if (reader.ValueTextEquals(MemberPlane))
		{
			return Elastic.Clients.Elasticsearch.GeoDistanceType.Plane;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberArc.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.GeoDistanceType.Arc;
		}

		if (string.Equals(value, MemberPlane.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.GeoDistanceType.Plane;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.GeoDistanceType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.GeoDistanceType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.GeoDistanceType.Arc:
				writer.WriteStringValue(MemberArc);
				break;
			case Elastic.Clients.Elasticsearch.GeoDistanceType.Plane:
				writer.WriteStringValue(MemberPlane);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.GeoDistanceType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.GeoDistanceType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.GeoDistanceType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}