// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class FieldSortNumericTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.FieldSortNumericType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberDate = System.Text.Json.JsonEncodedText.Encode("date");
	private static readonly System.Text.Json.JsonEncodedText MemberDateNanos = System.Text.Json.JsonEncodedText.Encode("date_nanos");
	private static readonly System.Text.Json.JsonEncodedText MemberDouble = System.Text.Json.JsonEncodedText.Encode("double");
	private static readonly System.Text.Json.JsonEncodedText MemberLong = System.Text.Json.JsonEncodedText.Encode("long");

	public override Elastic.Clients.Elasticsearch.FieldSortNumericType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberDate))
		{
			return Elastic.Clients.Elasticsearch.FieldSortNumericType.Date;
		}

		if (reader.ValueTextEquals(MemberDateNanos))
		{
			return Elastic.Clients.Elasticsearch.FieldSortNumericType.DateNanos;
		}

		if (reader.ValueTextEquals(MemberDouble))
		{
			return Elastic.Clients.Elasticsearch.FieldSortNumericType.Double;
		}

		if (reader.ValueTextEquals(MemberLong))
		{
			return Elastic.Clients.Elasticsearch.FieldSortNumericType.Long;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberDate.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.FieldSortNumericType.Date;
		}

		if (string.Equals(value, MemberDateNanos.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.FieldSortNumericType.DateNanos;
		}

		if (string.Equals(value, MemberDouble.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.FieldSortNumericType.Double;
		}

		if (string.Equals(value, MemberLong.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.FieldSortNumericType.Long;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.FieldSortNumericType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.FieldSortNumericType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.FieldSortNumericType.Date:
				writer.WriteStringValue(MemberDate);
				break;
			case Elastic.Clients.Elasticsearch.FieldSortNumericType.DateNanos:
				writer.WriteStringValue(MemberDateNanos);
				break;
			case Elastic.Clients.Elasticsearch.FieldSortNumericType.Double:
				writer.WriteStringValue(MemberDouble);
				break;
			case Elastic.Clients.Elasticsearch.FieldSortNumericType.Long:
				writer.WriteStringValue(MemberLong);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.FieldSortNumericType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.FieldSortNumericType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.FieldSortNumericType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}