// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.FieldSortConverter))]
public sealed partial class FieldSort
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldSort(Elastic.Clients.Elasticsearch.Field field)
	{
		Field = field;
	}
#if NET7_0_OR_GREATER
	public FieldSort()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FieldSort(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field Field { get; set; }
	public string? Format { get; set; }
	public object? Missing { get; set; }
	public Elastic.Clients.Elasticsearch.SortMode? Mode { get; set; }
	public Elastic.Clients.Elasticsearch.NestedSortValue? Nested { get; set; }
	public Elastic.Clients.Elasticsearch.FieldSortNumericType? NumericType { get; set; }
	public Elastic.Clients.Elasticsearch.SortOrder? Order { get; set; }
	public Elastic.Clients.Elasticsearch.Mapping.FieldType? UnmappedType { get; set; }
}

public readonly partial struct FieldSortDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.FieldSort Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldSortDescriptor(Elastic.Clients.Elasticsearch.FieldSort instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldSortDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.FieldSort(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.FieldSortDescriptor<TDocument>(Elastic.Clients.Elasticsearch.FieldSort instance) => new Elastic.Clients.Elasticsearch.FieldSortDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.FieldSort(Elastic.Clients.Elasticsearch.FieldSortDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor<TDocument> Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor<TDocument> Field(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor<TDocument> Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor<TDocument> Missing(object? value)
	{
		Instance.Missing = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor<TDocument> Mode(Elastic.Clients.Elasticsearch.SortMode? value)
	{
		Instance.Mode = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor<TDocument> Nested(Elastic.Clients.Elasticsearch.NestedSortValue? value)
	{
		Instance.Nested = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor<TDocument> Nested(System.Action<Elastic.Clients.Elasticsearch.NestedSortValueDescriptor<TDocument>> action)
	{
		Instance.Nested = Elastic.Clients.Elasticsearch.NestedSortValueDescriptor<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor<TDocument> NumericType(Elastic.Clients.Elasticsearch.FieldSortNumericType? value)
	{
		Instance.NumericType = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor<TDocument> Order(Elastic.Clients.Elasticsearch.SortOrder? value)
	{
		Instance.Order = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor<TDocument> UnmappedType(Elastic.Clients.Elasticsearch.Mapping.FieldType? value)
	{
		Instance.UnmappedType = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.FieldSort Build(System.Action<Elastic.Clients.Elasticsearch.FieldSortDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.FieldSortDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.FieldSort(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct FieldSortDescriptor
{
	internal Elastic.Clients.Elasticsearch.FieldSort Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldSortDescriptor(Elastic.Clients.Elasticsearch.FieldSort instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FieldSortDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.FieldSort(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.FieldSortDescriptor(Elastic.Clients.Elasticsearch.FieldSort instance) => new Elastic.Clients.Elasticsearch.FieldSortDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.FieldSort(Elastic.Clients.Elasticsearch.FieldSortDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor Field(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor Field<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.Field = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor Format(string? value)
	{
		Instance.Format = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor Missing(object? value)
	{
		Instance.Missing = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor Mode(Elastic.Clients.Elasticsearch.SortMode? value)
	{
		Instance.Mode = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor Nested(Elastic.Clients.Elasticsearch.NestedSortValue? value)
	{
		Instance.Nested = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor Nested(System.Action<Elastic.Clients.Elasticsearch.NestedSortValueDescriptor> action)
	{
		Instance.Nested = Elastic.Clients.Elasticsearch.NestedSortValueDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor Nested<T>(System.Action<Elastic.Clients.Elasticsearch.NestedSortValueDescriptor<T>> action)
	{
		Instance.Nested = Elastic.Clients.Elasticsearch.NestedSortValueDescriptor<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor NumericType(Elastic.Clients.Elasticsearch.FieldSortNumericType? value)
	{
		Instance.NumericType = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor Order(Elastic.Clients.Elasticsearch.SortOrder? value)
	{
		Instance.Order = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.FieldSortDescriptor UnmappedType(Elastic.Clients.Elasticsearch.Mapping.FieldType? value)
	{
		Instance.UnmappedType = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.FieldSort Build(System.Action<Elastic.Clients.Elasticsearch.FieldSortDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.FieldSortDescriptor(new Elastic.Clients.Elasticsearch.FieldSort(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}