// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.ExpandWildcardConverter))]
public enum ExpandWildcard
{
	/// <summary>
	/// <para>
	/// Match any data stream or index, including hidden ones.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "all")]
	All,
	/// <summary>
	/// <para>
	/// Match closed, non-hidden indices. Also matches any non-hidden data stream. Data streams cannot be closed.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "closed")]
	Closed,
	/// <summary>
	/// <para>
	/// Match hidden data streams and hidden indices. Must be combined with <c>open</c>, <c>closed</c>, or <c>both</c>.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "hidden")]
	Hidden,
	/// <summary>
	/// <para>
	/// Wildcard expressions are not accepted.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "none")]
	None,
	/// <summary>
	/// <para>
	/// Match open, non-hidden indices. Also matches any non-hidden data stream.
	/// </para>
	/// </summary>
	[System.Runtime.Serialization.EnumMember(Value = "open")]
	Open
}