// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

/// <summary>
/// <para>
/// Cause and details about a request failure. This class defines the properties common to all error types.
/// Additional details are also provided, that depend on the error type.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.ErrorCauseConverter))]
public sealed partial class ErrorCause
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ErrorCause(string type)
	{
		Type = type;
	}
#if NET7_0_OR_GREATER
	public ErrorCause()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ErrorCause()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ErrorCause(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public Elastic.Clients.Elasticsearch.ErrorCause? CausedBy { get; set; }

	/// <summary>
	/// <para>
	/// Additional details about the error
	/// </para>
	/// </summary>
	public System.Collections.Generic.IReadOnlyDictionary<string, object>? Metadata { get; set; }

	/// <summary>
	/// <para>
	/// A human-readable explanation of the error, in English.
	/// </para>
	/// </summary>
	public string? Reason { get; set; }
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.ErrorCause>? RootCause { get; set; }

	/// <summary>
	/// <para>
	/// The server stack trace. Present only if the <c>error_trace=true</c> parameter was sent with the request.
	/// </para>
	/// </summary>
	public string? StackTrace { get; set; }
	public System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.ErrorCause>? Suppressed { get; set; }

	/// <summary>
	/// <para>
	/// The type of error
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Type { get; set; }
}