// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Enrich.Json;

public sealed partial class PolicyTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Enrich.PolicyType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberGeoMatch = System.Text.Json.JsonEncodedText.Encode("geo_match");
	private static readonly System.Text.Json.JsonEncodedText MemberMatch = System.Text.Json.JsonEncodedText.Encode("match");
	private static readonly System.Text.Json.JsonEncodedText MemberRange = System.Text.Json.JsonEncodedText.Encode("range");

	public override Elastic.Clients.Elasticsearch.Enrich.PolicyType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberGeoMatch))
		{
			return Elastic.Clients.Elasticsearch.Enrich.PolicyType.GeoMatch;
		}

		if (reader.ValueTextEquals(MemberMatch))
		{
			return Elastic.Clients.Elasticsearch.Enrich.PolicyType.Match;
		}

		if (reader.ValueTextEquals(MemberRange))
		{
			return Elastic.Clients.Elasticsearch.Enrich.PolicyType.Range;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberGeoMatch.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Enrich.PolicyType.GeoMatch;
		}

		if (string.Equals(value, MemberMatch.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Enrich.PolicyType.Match;
		}

		if (string.Equals(value, MemberRange.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Enrich.PolicyType.Range;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Enrich.PolicyType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Enrich.PolicyType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Enrich.PolicyType.GeoMatch:
				writer.WriteStringValue(MemberGeoMatch);
				break;
			case Elastic.Clients.Elasticsearch.Enrich.PolicyType.Match:
				writer.WriteStringValue(MemberMatch);
				break;
			case Elastic.Clients.Elasticsearch.Enrich.PolicyType.Range:
				writer.WriteStringValue(MemberRange);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Enrich.PolicyType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Enrich.PolicyType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Enrich.PolicyType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}