// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Enrich.Json;

public sealed partial class EnrichPolicyPhaseConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase>
{
	private static readonly System.Text.Json.JsonEncodedText MemberCancelled = System.Text.Json.JsonEncodedText.Encode("CANCELLED");
	private static readonly System.Text.Json.JsonEncodedText MemberComplete = System.Text.Json.JsonEncodedText.Encode("COMPLETE");
	private static readonly System.Text.Json.JsonEncodedText MemberFailed = System.Text.Json.JsonEncodedText.Encode("FAILED");
	private static readonly System.Text.Json.JsonEncodedText MemberRunning = System.Text.Json.JsonEncodedText.Encode("RUNNING");
	private static readonly System.Text.Json.JsonEncodedText MemberScheduled = System.Text.Json.JsonEncodedText.Encode("SCHEDULED");

	public override Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberCancelled))
		{
			return Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase.Cancelled;
		}

		if (reader.ValueTextEquals(MemberComplete))
		{
			return Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase.Complete;
		}

		if (reader.ValueTextEquals(MemberFailed))
		{
			return Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase.Failed;
		}

		if (reader.ValueTextEquals(MemberRunning))
		{
			return Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase.Running;
		}

		if (reader.ValueTextEquals(MemberScheduled))
		{
			return Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase.Scheduled;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberCancelled.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase.Cancelled;
		}

		if (string.Equals(value, MemberComplete.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase.Complete;
		}

		if (string.Equals(value, MemberFailed.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase.Failed;
		}

		if (string.Equals(value, MemberRunning.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase.Running;
		}

		if (string.Equals(value, MemberScheduled.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase.Scheduled;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase.Cancelled:
				writer.WriteStringValue(MemberCancelled);
				break;
			case Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase.Complete:
				writer.WriteStringValue(MemberComplete);
				break;
			case Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase.Failed:
				writer.WriteStringValue(MemberFailed);
				break;
			case Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase.Running:
				writer.WriteStringValue(MemberRunning);
				break;
			case Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase.Scheduled:
				writer.WriteStringValue(MemberScheduled);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyPhase value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}