// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Enrich;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Enrich.Json.EnrichPolicyConverter))]
public sealed partial class EnrichPolicy
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EnrichPolicy(Elastic.Clients.Elasticsearch.Fields enrichFields, Elastic.Clients.Elasticsearch.Indices indices, Elastic.Clients.Elasticsearch.Field matchField)
	{
		EnrichFields = enrichFields;
		Indices = indices;
		MatchField = matchField;
	}
#if NET7_0_OR_GREATER
	public EnrichPolicy()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public EnrichPolicy()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal EnrichPolicy(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public string? ElasticsearchVersion { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Fields EnrichFields { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Indices Indices { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.Field MatchField { get; set; }
	public Elastic.Clients.Elasticsearch.Name? Name { get; set; }
	public Elastic.Clients.Elasticsearch.QueryDsl.Query? Query { get; set; }
}

public readonly partial struct EnrichPolicyDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EnrichPolicyDescriptor(Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EnrichPolicyDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy instance) => new Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy(Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<TDocument> descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<TDocument> ElasticsearchVersion(string? value)
	{
		Instance.ElasticsearchVersion = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<TDocument> EnrichFields(Elastic.Clients.Elasticsearch.Fields value)
	{
		Instance.EnrichFields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<TDocument> EnrichFields(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		Instance.EnrichFields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<TDocument> Indices(Elastic.Clients.Elasticsearch.Indices value)
	{
		Instance.Indices = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<TDocument> MatchField(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.MatchField = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<TDocument> MatchField(System.Linq.Expressions.Expression<System.Func<TDocument, object?>> value)
	{
		Instance.MatchField = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<TDocument> Name(Elastic.Clients.Elasticsearch.Name? value)
	{
		Instance.Name = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<TDocument> Query(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<TDocument> Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<TDocument>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy Build(System.Action<Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<TDocument>> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct EnrichPolicyDescriptor
{
	internal Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EnrichPolicyDescriptor(Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public EnrichPolicyDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor(Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy instance) => new Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy(Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor descriptor) => descriptor.Instance;

	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor ElasticsearchVersion(string? value)
	{
		Instance.ElasticsearchVersion = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor EnrichFields(Elastic.Clients.Elasticsearch.Fields value)
	{
		Instance.EnrichFields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor EnrichFields<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		Instance.EnrichFields = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor Indices(Elastic.Clients.Elasticsearch.Indices value)
	{
		Instance.Indices = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor MatchField(Elastic.Clients.Elasticsearch.Field value)
	{
		Instance.MatchField = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor MatchField<T>(System.Linq.Expressions.Expression<System.Func<T, object?>> value)
	{
		Instance.MatchField = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor Name(Elastic.Clients.Elasticsearch.Name? value)
	{
		Instance.Name = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor Query(Elastic.Clients.Elasticsearch.QueryDsl.Query? value)
	{
		Instance.Query = value;
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor Query(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor Query<T>(System.Action<Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>> action)
	{
		Instance.Query = Elastic.Clients.Elasticsearch.QueryDsl.QueryDescriptor<T>.Build(action);
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy Build(System.Action<Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Enrich.EnrichPolicyDescriptor(new Elastic.Clients.Elasticsearch.Enrich.EnrichPolicy(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}