// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Enrich;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Enrich.Json.CacheStatsConverter))]
public sealed partial class CacheStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public CacheStats(int count, int evictions, int hits, System.TimeSpan hitsTimeInMillis, int misses, System.TimeSpan missesTimeInMillis, string nodeId, long sizeInBytes)
	{
		Count = count;
		Evictions = evictions;
		Hits = hits;
		HitsTimeInMillis = hitsTimeInMillis;
		Misses = misses;
		MissesTimeInMillis = missesTimeInMillis;
		NodeId = nodeId;
		SizeInBytes = sizeInBytes;
	}
#if NET7_0_OR_GREATER
	public CacheStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public CacheStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal CacheStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	int Count { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	int Evictions { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	int Hits { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan HitsTimeInMillis { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	int Misses { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan MissesTimeInMillis { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string NodeId { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	long SizeInBytes { get; set; }
}