// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.ElasticsearchVersionInfoConverter))]
public sealed partial class ElasticsearchVersionInfo
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ElasticsearchVersionInfo(System.DateTimeOffset buildDate, string buildFlavor, string buildHash, bool buildSnapshot, string buildType, string luceneVersion, string minimumIndexCompatibilityVersion, string minimumWireCompatibilityVersion, string number)
	{
		BuildDate = buildDate;
		BuildFlavor = buildFlavor;
		BuildHash = buildHash;
		BuildSnapshot = buildSnapshot;
		BuildType = buildType;
		LuceneVersion = luceneVersion;
		MinimumIndexCompatibilityVersion = minimumIndexCompatibilityVersion;
		MinimumWireCompatibilityVersion = minimumWireCompatibilityVersion;
		Number = number;
	}
#if NET7_0_OR_GREATER
	public ElasticsearchVersionInfo()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ElasticsearchVersionInfo()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ElasticsearchVersionInfo(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The Elasticsearch Git commit's date.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.DateTimeOffset BuildDate { get; set; }

	/// <summary>
	/// <para>
	/// The build flavor. For example, <c>default</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string BuildFlavor { get; set; }

	/// <summary>
	/// <para>
	/// The Elasticsearch Git commit's SHA hash.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string BuildHash { get; set; }

	/// <summary>
	/// <para>
	/// Indicates whether the Elasticsearch build was a snapshot.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	bool BuildSnapshot { get; set; }

	/// <summary>
	/// <para>
	/// The build type that corresponds to how Elasticsearch was installed.
	/// For example, <c>docker</c>, <c>rpm</c>, or <c>tar</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string BuildType { get; set; }

	/// <summary>
	/// <para>
	/// The version number of Elasticsearch's underlying Lucene software.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string LuceneVersion { get; set; }

	/// <summary>
	/// <para>
	/// The minimum index version with which the responding node can read from disk.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string MinimumIndexCompatibilityVersion { get; set; }

	/// <summary>
	/// <para>
	/// The minimum node version with which the responding node can communicate.
	/// Also the minimum version from which you can perform a rolling upgrade.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string MinimumWireCompatibilityVersion { get; set; }

	/// <summary>
	/// <para>
	/// The Elasticsearch version number.
	/// </para>
	/// <para>
	/// ::: IMPORTANT: For Serverless deployments, this static value is always <c>8.11.0</c> and is used solely for backward compatibility with legacy clients.
	/// Serverless environments are versionless and automatically upgraded, so this value can be safely ignored.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Number { get; set; }
}