// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Json.DocStatsConverter))]
public sealed partial class DocStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public DocStats(long count, long totalSizeInBytes)
	{
		Count = count;
		TotalSizeInBytes = totalSizeInBytes;
	}
#if NET7_0_OR_GREATER
	public DocStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public DocStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal DocStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Total number of non-deleted documents across all primary shards assigned to selected nodes.
	/// This number is based on documents in Lucene segments and may include documents from nested fields.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long Count { get; set; }

	/// <summary>
	/// <para>
	/// Total number of deleted documents across all primary shards assigned to selected nodes.
	/// This number is based on documents in Lucene segments.
	/// Elasticsearch reclaims the disk space of deleted Lucene documents when a segment is merged.
	/// </para>
	/// </summary>
	public long? Deleted { get; set; }

	/// <summary>
	/// <para>
	/// Human readable total_size_in_bytes
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? TotalSize { get; set; }

	/// <summary>
	/// <para>
	/// Returns the total size in bytes of all documents in this stats.
	/// This value may be more reliable than store_stats.size_in_bytes in estimating the index size.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long TotalSizeInBytes { get; set; }
}