// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class DistanceUnitConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.DistanceUnit>
{
	private static readonly System.Text.Json.JsonEncodedText MemberCentimeters = System.Text.Json.JsonEncodedText.Encode("cm");
	private static readonly System.Text.Json.JsonEncodedText MemberFeet = System.Text.Json.JsonEncodedText.Encode("ft");
	private static readonly System.Text.Json.JsonEncodedText MemberInches = System.Text.Json.JsonEncodedText.Encode("in");
	private static readonly System.Text.Json.JsonEncodedText MemberKilometers = System.Text.Json.JsonEncodedText.Encode("km");
	private static readonly System.Text.Json.JsonEncodedText MemberMeters = System.Text.Json.JsonEncodedText.Encode("m");
	private static readonly System.Text.Json.JsonEncodedText MemberMiles = System.Text.Json.JsonEncodedText.Encode("mi");
	private static readonly System.Text.Json.JsonEncodedText MemberMillimeters = System.Text.Json.JsonEncodedText.Encode("mm");
	private static readonly System.Text.Json.JsonEncodedText MemberNauticMiles = System.Text.Json.JsonEncodedText.Encode("nmi");
	private static readonly System.Text.Json.JsonEncodedText MemberYards = System.Text.Json.JsonEncodedText.Encode("yd");

	public override Elastic.Clients.Elasticsearch.DistanceUnit Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberCentimeters))
		{
			return Elastic.Clients.Elasticsearch.DistanceUnit.Centimeters;
		}

		if (reader.ValueTextEquals(MemberFeet))
		{
			return Elastic.Clients.Elasticsearch.DistanceUnit.Feet;
		}

		if (reader.ValueTextEquals(MemberInches))
		{
			return Elastic.Clients.Elasticsearch.DistanceUnit.Inches;
		}

		if (reader.ValueTextEquals(MemberKilometers))
		{
			return Elastic.Clients.Elasticsearch.DistanceUnit.Kilometers;
		}

		if (reader.ValueTextEquals(MemberMeters))
		{
			return Elastic.Clients.Elasticsearch.DistanceUnit.Meters;
		}

		if (reader.ValueTextEquals(MemberMiles))
		{
			return Elastic.Clients.Elasticsearch.DistanceUnit.Miles;
		}

		if (reader.ValueTextEquals(MemberMillimeters))
		{
			return Elastic.Clients.Elasticsearch.DistanceUnit.Millimeters;
		}

		if (reader.ValueTextEquals(MemberNauticMiles))
		{
			return Elastic.Clients.Elasticsearch.DistanceUnit.NauticMiles;
		}

		if (reader.ValueTextEquals(MemberYards))
		{
			return Elastic.Clients.Elasticsearch.DistanceUnit.Yards;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberCentimeters.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DistanceUnit.Centimeters;
		}

		if (string.Equals(value, MemberFeet.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DistanceUnit.Feet;
		}

		if (string.Equals(value, MemberInches.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DistanceUnit.Inches;
		}

		if (string.Equals(value, MemberKilometers.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DistanceUnit.Kilometers;
		}

		if (string.Equals(value, MemberMeters.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DistanceUnit.Meters;
		}

		if (string.Equals(value, MemberMiles.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DistanceUnit.Miles;
		}

		if (string.Equals(value, MemberMillimeters.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DistanceUnit.Millimeters;
		}

		if (string.Equals(value, MemberNauticMiles.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DistanceUnit.NauticMiles;
		}

		if (string.Equals(value, MemberYards.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DistanceUnit.Yards;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.DistanceUnit)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.DistanceUnit value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.DistanceUnit.Centimeters:
				writer.WriteStringValue(MemberCentimeters);
				break;
			case Elastic.Clients.Elasticsearch.DistanceUnit.Feet:
				writer.WriteStringValue(MemberFeet);
				break;
			case Elastic.Clients.Elasticsearch.DistanceUnit.Inches:
				writer.WriteStringValue(MemberInches);
				break;
			case Elastic.Clients.Elasticsearch.DistanceUnit.Kilometers:
				writer.WriteStringValue(MemberKilometers);
				break;
			case Elastic.Clients.Elasticsearch.DistanceUnit.Meters:
				writer.WriteStringValue(MemberMeters);
				break;
			case Elastic.Clients.Elasticsearch.DistanceUnit.Miles:
				writer.WriteStringValue(MemberMiles);
				break;
			case Elastic.Clients.Elasticsearch.DistanceUnit.Millimeters:
				writer.WriteStringValue(MemberMillimeters);
				break;
			case Elastic.Clients.Elasticsearch.DistanceUnit.NauticMiles:
				writer.WriteStringValue(MemberNauticMiles);
				break;
			case Elastic.Clients.Elasticsearch.DistanceUnit.Yards:
				writer.WriteStringValue(MemberYards);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.DistanceUnit)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.DistanceUnit ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.DistanceUnit value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}