// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class DFRBasicModelConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.DFRBasicModel>
{
	private static readonly System.Text.Json.JsonEncodedText MemberBe = System.Text.Json.JsonEncodedText.Encode("be");
	private static readonly System.Text.Json.JsonEncodedText MemberD = System.Text.Json.JsonEncodedText.Encode("d");
	private static readonly System.Text.Json.JsonEncodedText MemberG = System.Text.Json.JsonEncodedText.Encode("g");
	private static readonly System.Text.Json.JsonEncodedText MemberIf = System.Text.Json.JsonEncodedText.Encode("if");
	private static readonly System.Text.Json.JsonEncodedText MemberIn = System.Text.Json.JsonEncodedText.Encode("in");
	private static readonly System.Text.Json.JsonEncodedText MemberIne = System.Text.Json.JsonEncodedText.Encode("ine");
	private static readonly System.Text.Json.JsonEncodedText MemberP = System.Text.Json.JsonEncodedText.Encode("p");

	public override Elastic.Clients.Elasticsearch.DFRBasicModel Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberBe))
		{
			return Elastic.Clients.Elasticsearch.DFRBasicModel.Be;
		}

		if (reader.ValueTextEquals(MemberD))
		{
			return Elastic.Clients.Elasticsearch.DFRBasicModel.D;
		}

		if (reader.ValueTextEquals(MemberG))
		{
			return Elastic.Clients.Elasticsearch.DFRBasicModel.G;
		}

		if (reader.ValueTextEquals(MemberIf))
		{
			return Elastic.Clients.Elasticsearch.DFRBasicModel.If;
		}

		if (reader.ValueTextEquals(MemberIn))
		{
			return Elastic.Clients.Elasticsearch.DFRBasicModel.In;
		}

		if (reader.ValueTextEquals(MemberIne))
		{
			return Elastic.Clients.Elasticsearch.DFRBasicModel.Ine;
		}

		if (reader.ValueTextEquals(MemberP))
		{
			return Elastic.Clients.Elasticsearch.DFRBasicModel.P;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberBe.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DFRBasicModel.Be;
		}

		if (string.Equals(value, MemberD.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DFRBasicModel.D;
		}

		if (string.Equals(value, MemberG.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DFRBasicModel.G;
		}

		if (string.Equals(value, MemberIf.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DFRBasicModel.If;
		}

		if (string.Equals(value, MemberIn.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DFRBasicModel.In;
		}

		if (string.Equals(value, MemberIne.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DFRBasicModel.Ine;
		}

		if (string.Equals(value, MemberP.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DFRBasicModel.P;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.DFRBasicModel)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.DFRBasicModel value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.DFRBasicModel.Be:
				writer.WriteStringValue(MemberBe);
				break;
			case Elastic.Clients.Elasticsearch.DFRBasicModel.D:
				writer.WriteStringValue(MemberD);
				break;
			case Elastic.Clients.Elasticsearch.DFRBasicModel.G:
				writer.WriteStringValue(MemberG);
				break;
			case Elastic.Clients.Elasticsearch.DFRBasicModel.If:
				writer.WriteStringValue(MemberIf);
				break;
			case Elastic.Clients.Elasticsearch.DFRBasicModel.In:
				writer.WriteStringValue(MemberIn);
				break;
			case Elastic.Clients.Elasticsearch.DFRBasicModel.Ine:
				writer.WriteStringValue(MemberIne);
				break;
			case Elastic.Clients.Elasticsearch.DFRBasicModel.P:
				writer.WriteStringValue(MemberP);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.DFRBasicModel)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.DFRBasicModel ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.DFRBasicModel value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}