// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class DFRAfterEffectConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.DFRAfterEffect>
{
	private static readonly System.Text.Json.JsonEncodedText MemberB = System.Text.Json.JsonEncodedText.Encode("b");
	private static readonly System.Text.Json.JsonEncodedText MemberL = System.Text.Json.JsonEncodedText.Encode("l");
	private static readonly System.Text.Json.JsonEncodedText MemberNo = System.Text.Json.JsonEncodedText.Encode("no");

	public override Elastic.Clients.Elasticsearch.DFRAfterEffect Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberB))
		{
			return Elastic.Clients.Elasticsearch.DFRAfterEffect.B;
		}

		if (reader.ValueTextEquals(MemberL))
		{
			return Elastic.Clients.Elasticsearch.DFRAfterEffect.L;
		}

		if (reader.ValueTextEquals(MemberNo))
		{
			return Elastic.Clients.Elasticsearch.DFRAfterEffect.No;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberB.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DFRAfterEffect.B;
		}

		if (string.Equals(value, MemberL.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DFRAfterEffect.L;
		}

		if (string.Equals(value, MemberNo.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DFRAfterEffect.No;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.DFRAfterEffect)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.DFRAfterEffect value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.DFRAfterEffect.B:
				writer.WriteStringValue(MemberB);
				break;
			case Elastic.Clients.Elasticsearch.DFRAfterEffect.L:
				writer.WriteStringValue(MemberL);
				break;
			case Elastic.Clients.Elasticsearch.DFRAfterEffect.No:
				writer.WriteStringValue(MemberNo);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.DFRAfterEffect)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.DFRAfterEffect ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.DFRAfterEffect value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}