// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Json;

public sealed partial class DFIIndependenceMeasureConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.DFIIndependenceMeasure>
{
	private static readonly System.Text.Json.JsonEncodedText MemberChisquared = System.Text.Json.JsonEncodedText.Encode("chisquared");
	private static readonly System.Text.Json.JsonEncodedText MemberSaturated = System.Text.Json.JsonEncodedText.Encode("saturated");
	private static readonly System.Text.Json.JsonEncodedText MemberStandardized = System.Text.Json.JsonEncodedText.Encode("standardized");

	public override Elastic.Clients.Elasticsearch.DFIIndependenceMeasure Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberChisquared))
		{
			return Elastic.Clients.Elasticsearch.DFIIndependenceMeasure.Chisquared;
		}

		if (reader.ValueTextEquals(MemberSaturated))
		{
			return Elastic.Clients.Elasticsearch.DFIIndependenceMeasure.Saturated;
		}

		if (reader.ValueTextEquals(MemberStandardized))
		{
			return Elastic.Clients.Elasticsearch.DFIIndependenceMeasure.Standardized;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberChisquared.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DFIIndependenceMeasure.Chisquared;
		}

		if (string.Equals(value, MemberSaturated.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DFIIndependenceMeasure.Saturated;
		}

		if (string.Equals(value, MemberStandardized.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.DFIIndependenceMeasure.Standardized;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.DFIIndependenceMeasure)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.DFIIndependenceMeasure value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.DFIIndependenceMeasure.Chisquared:
				writer.WriteStringValue(MemberChisquared);
				break;
			case Elastic.Clients.Elasticsearch.DFIIndependenceMeasure.Saturated:
				writer.WriteStringValue(MemberSaturated);
				break;
			case Elastic.Clients.Elasticsearch.DFIIndependenceMeasure.Standardized:
				writer.WriteStringValue(MemberStandardized);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.DFIIndependenceMeasure)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.DFIIndependenceMeasure ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.DFIIndependenceMeasure value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}