// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.CrossClusterReplication;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.CrossClusterReplication.Json.ShardStatsConverter))]
public sealed partial class ShardStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public ShardStats(long bytesRead, long failedReadRequests, long failedWriteRequests, long followerAliasesVersion, long followerGlobalCheckpoint, string followerIndex, long followerMappingVersion, long followerMaxSeqNo, long followerSettingsVersion, long lastRequestedSeqNo, long leaderGlobalCheckpoint, string leaderIndex, long leaderMaxSeqNo, long operationsRead, long operationsWritten, int outstandingReadRequests, int outstandingWriteRequests, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.CrossClusterReplication.ReadException> readExceptions, string remoteCluster, int shardId, long successfulReadRequests, long successfulWriteRequests, System.TimeSpan timeSinceLastReadMillis, System.TimeSpan totalReadRemoteExecTimeMillis, System.TimeSpan totalReadTimeMillis, System.TimeSpan totalWriteTimeMillis, long writeBufferOperationCount, Elastic.Clients.Elasticsearch.ByteSize writeBufferSizeInBytes)
	{
		BytesRead = bytesRead;
		FailedReadRequests = failedReadRequests;
		FailedWriteRequests = failedWriteRequests;
		FollowerAliasesVersion = followerAliasesVersion;
		FollowerGlobalCheckpoint = followerGlobalCheckpoint;
		FollowerIndex = followerIndex;
		FollowerMappingVersion = followerMappingVersion;
		FollowerMaxSeqNo = followerMaxSeqNo;
		FollowerSettingsVersion = followerSettingsVersion;
		LastRequestedSeqNo = lastRequestedSeqNo;
		LeaderGlobalCheckpoint = leaderGlobalCheckpoint;
		LeaderIndex = leaderIndex;
		LeaderMaxSeqNo = leaderMaxSeqNo;
		OperationsRead = operationsRead;
		OperationsWritten = operationsWritten;
		OutstandingReadRequests = outstandingReadRequests;
		OutstandingWriteRequests = outstandingWriteRequests;
		ReadExceptions = readExceptions;
		RemoteCluster = remoteCluster;
		ShardId = shardId;
		SuccessfulReadRequests = successfulReadRequests;
		SuccessfulWriteRequests = successfulWriteRequests;
		TimeSinceLastReadMillis = timeSinceLastReadMillis;
		TotalReadRemoteExecTimeMillis = totalReadRemoteExecTimeMillis;
		TotalReadTimeMillis = totalReadTimeMillis;
		TotalWriteTimeMillis = totalWriteTimeMillis;
		WriteBufferOperationCount = writeBufferOperationCount;
		WriteBufferSizeInBytes = writeBufferSizeInBytes;
	}
#if NET7_0_OR_GREATER
	public ShardStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public ShardStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal ShardStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The total of transferred bytes read from the leader.
	/// This is only an estimate and does not account for compression if enabled.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long BytesRead { get; set; }

	/// <summary>
	/// <para>
	/// The number of failed reads.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long FailedReadRequests { get; set; }

	/// <summary>
	/// <para>
	/// The number of failed bulk write requests on the follower.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long FailedWriteRequests { get; set; }
	public Elastic.Clients.Elasticsearch.ErrorCause? FatalException { get; set; }

	/// <summary>
	/// <para>
	/// The index aliases version the follower is synced up to.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long FollowerAliasesVersion { get; set; }

	/// <summary>
	/// <para>
	/// The current global checkpoint on the follower.
	/// The difference between the <c>leader_global_checkpoint</c> and the <c>follower_global_checkpoint</c> is an indication of how much the follower is lagging the leader.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long FollowerGlobalCheckpoint { get; set; }

	/// <summary>
	/// <para>
	/// The name of the follower index.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string FollowerIndex { get; set; }

	/// <summary>
	/// <para>
	/// The mapping version the follower is synced up to.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long FollowerMappingVersion { get; set; }

	/// <summary>
	/// <para>
	/// The current maximum sequence number on the follower.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long FollowerMaxSeqNo { get; set; }

	/// <summary>
	/// <para>
	/// The index settings version the follower is synced up to.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long FollowerSettingsVersion { get; set; }

	/// <summary>
	/// <para>
	/// The starting sequence number of the last batch of operations requested from the leader.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long LastRequestedSeqNo { get; set; }

	/// <summary>
	/// <para>
	/// The current global checkpoint on the leader known to the follower task.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long LeaderGlobalCheckpoint { get; set; }

	/// <summary>
	/// <para>
	/// The name of the index in the leader cluster being followed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string LeaderIndex { get; set; }

	/// <summary>
	/// <para>
	/// The current maximum sequence number on the leader known to the follower task.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long LeaderMaxSeqNo { get; set; }

	/// <summary>
	/// <para>
	/// The total number of operations read from the leader.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long OperationsRead { get; set; }

	/// <summary>
	/// <para>
	/// The number of operations written on the follower.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long OperationsWritten { get; set; }

	/// <summary>
	/// <para>
	/// The number of active read requests from the follower.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int OutstandingReadRequests { get; set; }

	/// <summary>
	/// <para>
	/// The number of active bulk write requests on the follower.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int OutstandingWriteRequests { get; set; }

	/// <summary>
	/// <para>
	/// An array of objects representing failed reads.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.CrossClusterReplication.ReadException> ReadExceptions { get; set; }

	/// <summary>
	/// <para>
	/// The remote cluster containing the leader index.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string RemoteCluster { get; set; }

	/// <summary>
	/// <para>
	/// The numerical shard ID, with values from 0 to one less than the number of replicas.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int ShardId { get; set; }

	/// <summary>
	/// <para>
	/// The number of successful fetches.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long SuccessfulReadRequests { get; set; }

	/// <summary>
	/// <para>
	/// The number of bulk write requests run on the follower.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long SuccessfulWriteRequests { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? TimeSinceLastRead { get; set; }

	/// <summary>
	/// <para>
	/// The number of milliseconds since a read request was sent to the leader.
	/// When the follower is caught up to the leader, this number will increase up to the configured <c>read_poll_timeout</c> at which point another read request will be sent to the leader.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan TimeSinceLastReadMillis { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? TotalReadRemoteExecTime { get; set; }

	/// <summary>
	/// <para>
	/// The total time reads spent running on the remote cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan TotalReadRemoteExecTimeMillis { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? TotalReadTime { get; set; }

	/// <summary>
	/// <para>
	/// The total time reads were outstanding, measured from the time a read was sent to the leader to the time a reply was returned to the follower.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan TotalReadTimeMillis { get; set; }
	public Elastic.Clients.Elasticsearch.Duration? TotalWriteTime { get; set; }

	/// <summary>
	/// <para>
	/// The total time spent writing on the follower.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.TimeSpan TotalWriteTimeMillis { get; set; }

	/// <summary>
	/// <para>
	/// The number of write operations queued on the follower.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long WriteBufferOperationCount { get; set; }

	/// <summary>
	/// <para>
	/// The total number of bytes of operations currently queued for writing.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.ByteSize WriteBufferSizeInBytes { get; set; }
}