// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.CrossClusterReplication.Json;

public sealed partial class ShardStatsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.CrossClusterReplication.ShardStats>
{
	private static readonly System.Text.Json.JsonEncodedText PropBytesRead = System.Text.Json.JsonEncodedText.Encode("bytes_read");
	private static readonly System.Text.Json.JsonEncodedText PropFailedReadRequests = System.Text.Json.JsonEncodedText.Encode("failed_read_requests");
	private static readonly System.Text.Json.JsonEncodedText PropFailedWriteRequests = System.Text.Json.JsonEncodedText.Encode("failed_write_requests");
	private static readonly System.Text.Json.JsonEncodedText PropFatalException = System.Text.Json.JsonEncodedText.Encode("fatal_exception");
	private static readonly System.Text.Json.JsonEncodedText PropFollowerAliasesVersion = System.Text.Json.JsonEncodedText.Encode("follower_aliases_version");
	private static readonly System.Text.Json.JsonEncodedText PropFollowerGlobalCheckpoint = System.Text.Json.JsonEncodedText.Encode("follower_global_checkpoint");
	private static readonly System.Text.Json.JsonEncodedText PropFollowerIndex = System.Text.Json.JsonEncodedText.Encode("follower_index");
	private static readonly System.Text.Json.JsonEncodedText PropFollowerMappingVersion = System.Text.Json.JsonEncodedText.Encode("follower_mapping_version");
	private static readonly System.Text.Json.JsonEncodedText PropFollowerMaxSeqNo = System.Text.Json.JsonEncodedText.Encode("follower_max_seq_no");
	private static readonly System.Text.Json.JsonEncodedText PropFollowerSettingsVersion = System.Text.Json.JsonEncodedText.Encode("follower_settings_version");
	private static readonly System.Text.Json.JsonEncodedText PropLastRequestedSeqNo = System.Text.Json.JsonEncodedText.Encode("last_requested_seq_no");
	private static readonly System.Text.Json.JsonEncodedText PropLeaderGlobalCheckpoint = System.Text.Json.JsonEncodedText.Encode("leader_global_checkpoint");
	private static readonly System.Text.Json.JsonEncodedText PropLeaderIndex = System.Text.Json.JsonEncodedText.Encode("leader_index");
	private static readonly System.Text.Json.JsonEncodedText PropLeaderMaxSeqNo = System.Text.Json.JsonEncodedText.Encode("leader_max_seq_no");
	private static readonly System.Text.Json.JsonEncodedText PropOperationsRead = System.Text.Json.JsonEncodedText.Encode("operations_read");
	private static readonly System.Text.Json.JsonEncodedText PropOperationsWritten = System.Text.Json.JsonEncodedText.Encode("operations_written");
	private static readonly System.Text.Json.JsonEncodedText PropOutstandingReadRequests = System.Text.Json.JsonEncodedText.Encode("outstanding_read_requests");
	private static readonly System.Text.Json.JsonEncodedText PropOutstandingWriteRequests = System.Text.Json.JsonEncodedText.Encode("outstanding_write_requests");
	private static readonly System.Text.Json.JsonEncodedText PropReadExceptions = System.Text.Json.JsonEncodedText.Encode("read_exceptions");
	private static readonly System.Text.Json.JsonEncodedText PropRemoteCluster = System.Text.Json.JsonEncodedText.Encode("remote_cluster");
	private static readonly System.Text.Json.JsonEncodedText PropShardId = System.Text.Json.JsonEncodedText.Encode("shard_id");
	private static readonly System.Text.Json.JsonEncodedText PropSuccessfulReadRequests = System.Text.Json.JsonEncodedText.Encode("successful_read_requests");
	private static readonly System.Text.Json.JsonEncodedText PropSuccessfulWriteRequests = System.Text.Json.JsonEncodedText.Encode("successful_write_requests");
	private static readonly System.Text.Json.JsonEncodedText PropTimeSinceLastRead = System.Text.Json.JsonEncodedText.Encode("time_since_last_read");
	private static readonly System.Text.Json.JsonEncodedText PropTimeSinceLastReadMillis = System.Text.Json.JsonEncodedText.Encode("time_since_last_read_millis");
	private static readonly System.Text.Json.JsonEncodedText PropTotalReadRemoteExecTime = System.Text.Json.JsonEncodedText.Encode("total_read_remote_exec_time");
	private static readonly System.Text.Json.JsonEncodedText PropTotalReadRemoteExecTimeMillis = System.Text.Json.JsonEncodedText.Encode("total_read_remote_exec_time_millis");
	private static readonly System.Text.Json.JsonEncodedText PropTotalReadTime = System.Text.Json.JsonEncodedText.Encode("total_read_time");
	private static readonly System.Text.Json.JsonEncodedText PropTotalReadTimeMillis = System.Text.Json.JsonEncodedText.Encode("total_read_time_millis");
	private static readonly System.Text.Json.JsonEncodedText PropTotalWriteTime = System.Text.Json.JsonEncodedText.Encode("total_write_time");
	private static readonly System.Text.Json.JsonEncodedText PropTotalWriteTimeMillis = System.Text.Json.JsonEncodedText.Encode("total_write_time_millis");
	private static readonly System.Text.Json.JsonEncodedText PropWriteBufferOperationCount = System.Text.Json.JsonEncodedText.Encode("write_buffer_operation_count");
	private static readonly System.Text.Json.JsonEncodedText PropWriteBufferSizeInBytes = System.Text.Json.JsonEncodedText.Encode("write_buffer_size_in_bytes");

	public override Elastic.Clients.Elasticsearch.CrossClusterReplication.ShardStats Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<long> propBytesRead = default;
		LocalJsonValue<long> propFailedReadRequests = default;
		LocalJsonValue<long> propFailedWriteRequests = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ErrorCause?> propFatalException = default;
		LocalJsonValue<long> propFollowerAliasesVersion = default;
		LocalJsonValue<long> propFollowerGlobalCheckpoint = default;
		LocalJsonValue<string> propFollowerIndex = default;
		LocalJsonValue<long> propFollowerMappingVersion = default;
		LocalJsonValue<long> propFollowerMaxSeqNo = default;
		LocalJsonValue<long> propFollowerSettingsVersion = default;
		LocalJsonValue<long> propLastRequestedSeqNo = default;
		LocalJsonValue<long> propLeaderGlobalCheckpoint = default;
		LocalJsonValue<string> propLeaderIndex = default;
		LocalJsonValue<long> propLeaderMaxSeqNo = default;
		LocalJsonValue<long> propOperationsRead = default;
		LocalJsonValue<long> propOperationsWritten = default;
		LocalJsonValue<int> propOutstandingReadRequests = default;
		LocalJsonValue<int> propOutstandingWriteRequests = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.CrossClusterReplication.ReadException>> propReadExceptions = default;
		LocalJsonValue<string> propRemoteCluster = default;
		LocalJsonValue<int> propShardId = default;
		LocalJsonValue<long> propSuccessfulReadRequests = default;
		LocalJsonValue<long> propSuccessfulWriteRequests = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propTimeSinceLastRead = default;
		LocalJsonValue<System.TimeSpan> propTimeSinceLastReadMillis = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propTotalReadRemoteExecTime = default;
		LocalJsonValue<System.TimeSpan> propTotalReadRemoteExecTimeMillis = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propTotalReadTime = default;
		LocalJsonValue<System.TimeSpan> propTotalReadTimeMillis = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.Duration?> propTotalWriteTime = default;
		LocalJsonValue<System.TimeSpan> propTotalWriteTimeMillis = default;
		LocalJsonValue<long> propWriteBufferOperationCount = default;
		LocalJsonValue<Elastic.Clients.Elasticsearch.ByteSize> propWriteBufferSizeInBytes = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propBytesRead.TryReadProperty(ref reader, options, PropBytesRead, null))
			{
				continue;
			}

			if (propFailedReadRequests.TryReadProperty(ref reader, options, PropFailedReadRequests, null))
			{
				continue;
			}

			if (propFailedWriteRequests.TryReadProperty(ref reader, options, PropFailedWriteRequests, null))
			{
				continue;
			}

			if (propFatalException.TryReadProperty(ref reader, options, PropFatalException, null))
			{
				continue;
			}

			if (propFollowerAliasesVersion.TryReadProperty(ref reader, options, PropFollowerAliasesVersion, null))
			{
				continue;
			}

			if (propFollowerGlobalCheckpoint.TryReadProperty(ref reader, options, PropFollowerGlobalCheckpoint, null))
			{
				continue;
			}

			if (propFollowerIndex.TryReadProperty(ref reader, options, PropFollowerIndex, null))
			{
				continue;
			}

			if (propFollowerMappingVersion.TryReadProperty(ref reader, options, PropFollowerMappingVersion, null))
			{
				continue;
			}

			if (propFollowerMaxSeqNo.TryReadProperty(ref reader, options, PropFollowerMaxSeqNo, null))
			{
				continue;
			}

			if (propFollowerSettingsVersion.TryReadProperty(ref reader, options, PropFollowerSettingsVersion, null))
			{
				continue;
			}

			if (propLastRequestedSeqNo.TryReadProperty(ref reader, options, PropLastRequestedSeqNo, null))
			{
				continue;
			}

			if (propLeaderGlobalCheckpoint.TryReadProperty(ref reader, options, PropLeaderGlobalCheckpoint, null))
			{
				continue;
			}

			if (propLeaderIndex.TryReadProperty(ref reader, options, PropLeaderIndex, null))
			{
				continue;
			}

			if (propLeaderMaxSeqNo.TryReadProperty(ref reader, options, PropLeaderMaxSeqNo, null))
			{
				continue;
			}

			if (propOperationsRead.TryReadProperty(ref reader, options, PropOperationsRead, null))
			{
				continue;
			}

			if (propOperationsWritten.TryReadProperty(ref reader, options, PropOperationsWritten, null))
			{
				continue;
			}

			if (propOutstandingReadRequests.TryReadProperty(ref reader, options, PropOutstandingReadRequests, null))
			{
				continue;
			}

			if (propOutstandingWriteRequests.TryReadProperty(ref reader, options, PropOutstandingWriteRequests, null))
			{
				continue;
			}

			if (propReadExceptions.TryReadProperty(ref reader, options, PropReadExceptions, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.CrossClusterReplication.ReadException> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.CrossClusterReplication.ReadException>(o, null)!))
			{
				continue;
			}

			if (propRemoteCluster.TryReadProperty(ref reader, options, PropRemoteCluster, null))
			{
				continue;
			}

			if (propShardId.TryReadProperty(ref reader, options, PropShardId, null))
			{
				continue;
			}

			if (propSuccessfulReadRequests.TryReadProperty(ref reader, options, PropSuccessfulReadRequests, null))
			{
				continue;
			}

			if (propSuccessfulWriteRequests.TryReadProperty(ref reader, options, PropSuccessfulWriteRequests, null))
			{
				continue;
			}

			if (propTimeSinceLastRead.TryReadProperty(ref reader, options, PropTimeSinceLastRead, null))
			{
				continue;
			}

			if (propTimeSinceLastReadMillis.TryReadProperty(ref reader, options, PropTimeSinceLastReadMillis, static System.TimeSpan (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker))))
			{
				continue;
			}

			if (propTotalReadRemoteExecTime.TryReadProperty(ref reader, options, PropTotalReadRemoteExecTime, null))
			{
				continue;
			}

			if (propTotalReadRemoteExecTimeMillis.TryReadProperty(ref reader, options, PropTotalReadRemoteExecTimeMillis, static System.TimeSpan (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker))))
			{
				continue;
			}

			if (propTotalReadTime.TryReadProperty(ref reader, options, PropTotalReadTime, null))
			{
				continue;
			}

			if (propTotalReadTimeMillis.TryReadProperty(ref reader, options, PropTotalReadTimeMillis, static System.TimeSpan (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker))))
			{
				continue;
			}

			if (propTotalWriteTime.TryReadProperty(ref reader, options, PropTotalWriteTime, null))
			{
				continue;
			}

			if (propTotalWriteTimeMillis.TryReadProperty(ref reader, options, PropTotalWriteTimeMillis, static System.TimeSpan (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadValueEx<System.TimeSpan>(o, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker))))
			{
				continue;
			}

			if (propWriteBufferOperationCount.TryReadProperty(ref reader, options, PropWriteBufferOperationCount, null))
			{
				continue;
			}

			if (propWriteBufferSizeInBytes.TryReadProperty(ref reader, options, PropWriteBufferSizeInBytes, null))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.CrossClusterReplication.ShardStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			BytesRead = propBytesRead.Value,
			FailedReadRequests = propFailedReadRequests.Value,
			FailedWriteRequests = propFailedWriteRequests.Value,
			FatalException = propFatalException.Value,
			FollowerAliasesVersion = propFollowerAliasesVersion.Value,
			FollowerGlobalCheckpoint = propFollowerGlobalCheckpoint.Value,
			FollowerIndex = propFollowerIndex.Value,
			FollowerMappingVersion = propFollowerMappingVersion.Value,
			FollowerMaxSeqNo = propFollowerMaxSeqNo.Value,
			FollowerSettingsVersion = propFollowerSettingsVersion.Value,
			LastRequestedSeqNo = propLastRequestedSeqNo.Value,
			LeaderGlobalCheckpoint = propLeaderGlobalCheckpoint.Value,
			LeaderIndex = propLeaderIndex.Value,
			LeaderMaxSeqNo = propLeaderMaxSeqNo.Value,
			OperationsRead = propOperationsRead.Value,
			OperationsWritten = propOperationsWritten.Value,
			OutstandingReadRequests = propOutstandingReadRequests.Value,
			OutstandingWriteRequests = propOutstandingWriteRequests.Value,
			ReadExceptions = propReadExceptions.Value,
			RemoteCluster = propRemoteCluster.Value,
			ShardId = propShardId.Value,
			SuccessfulReadRequests = propSuccessfulReadRequests.Value,
			SuccessfulWriteRequests = propSuccessfulWriteRequests.Value,
			TimeSinceLastRead = propTimeSinceLastRead.Value,
			TimeSinceLastReadMillis = propTimeSinceLastReadMillis.Value,
			TotalReadRemoteExecTime = propTotalReadRemoteExecTime.Value,
			TotalReadRemoteExecTimeMillis = propTotalReadRemoteExecTimeMillis.Value,
			TotalReadTime = propTotalReadTime.Value,
			TotalReadTimeMillis = propTotalReadTimeMillis.Value,
			TotalWriteTime = propTotalWriteTime.Value,
			TotalWriteTimeMillis = propTotalWriteTimeMillis.Value,
			WriteBufferOperationCount = propWriteBufferOperationCount.Value,
			WriteBufferSizeInBytes = propWriteBufferSizeInBytes.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.CrossClusterReplication.ShardStats value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropBytesRead, value.BytesRead, null, null);
		writer.WriteProperty(options, PropFailedReadRequests, value.FailedReadRequests, null, null);
		writer.WriteProperty(options, PropFailedWriteRequests, value.FailedWriteRequests, null, null);
		writer.WriteProperty(options, PropFatalException, value.FatalException, null, null);
		writer.WriteProperty(options, PropFollowerAliasesVersion, value.FollowerAliasesVersion, null, null);
		writer.WriteProperty(options, PropFollowerGlobalCheckpoint, value.FollowerGlobalCheckpoint, null, null);
		writer.WriteProperty(options, PropFollowerIndex, value.FollowerIndex, null, null);
		writer.WriteProperty(options, PropFollowerMappingVersion, value.FollowerMappingVersion, null, null);
		writer.WriteProperty(options, PropFollowerMaxSeqNo, value.FollowerMaxSeqNo, null, null);
		writer.WriteProperty(options, PropFollowerSettingsVersion, value.FollowerSettingsVersion, null, null);
		writer.WriteProperty(options, PropLastRequestedSeqNo, value.LastRequestedSeqNo, null, null);
		writer.WriteProperty(options, PropLeaderGlobalCheckpoint, value.LeaderGlobalCheckpoint, null, null);
		writer.WriteProperty(options, PropLeaderIndex, value.LeaderIndex, null, null);
		writer.WriteProperty(options, PropLeaderMaxSeqNo, value.LeaderMaxSeqNo, null, null);
		writer.WriteProperty(options, PropOperationsRead, value.OperationsRead, null, null);
		writer.WriteProperty(options, PropOperationsWritten, value.OperationsWritten, null, null);
		writer.WriteProperty(options, PropOutstandingReadRequests, value.OutstandingReadRequests, null, null);
		writer.WriteProperty(options, PropOutstandingWriteRequests, value.OutstandingWriteRequests, null, null);
		writer.WriteProperty(options, PropReadExceptions, value.ReadExceptions, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.CrossClusterReplication.ReadException> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.CrossClusterReplication.ReadException>(o, v, null));
		writer.WriteProperty(options, PropRemoteCluster, value.RemoteCluster, null, null);
		writer.WriteProperty(options, PropShardId, value.ShardId, null, null);
		writer.WriteProperty(options, PropSuccessfulReadRequests, value.SuccessfulReadRequests, null, null);
		writer.WriteProperty(options, PropSuccessfulWriteRequests, value.SuccessfulWriteRequests, null, null);
		writer.WriteProperty(options, PropTimeSinceLastRead, value.TimeSinceLastRead, null, null);
		writer.WriteProperty(options, PropTimeSinceLastReadMillis, value.TimeSinceLastReadMillis, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan v) => w.WriteValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker)));
		writer.WriteProperty(options, PropTotalReadRemoteExecTime, value.TotalReadRemoteExecTime, null, null);
		writer.WriteProperty(options, PropTotalReadRemoteExecTimeMillis, value.TotalReadRemoteExecTimeMillis, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan v) => w.WriteValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker)));
		writer.WriteProperty(options, PropTotalReadTime, value.TotalReadTime, null, null);
		writer.WriteProperty(options, PropTotalReadTimeMillis, value.TotalReadTimeMillis, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan v) => w.WriteValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker)));
		writer.WriteProperty(options, PropTotalWriteTime, value.TotalWriteTime, null, null);
		writer.WriteProperty(options, PropTotalWriteTimeMillis, value.TotalWriteTimeMillis, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.TimeSpan v) => w.WriteValueEx<System.TimeSpan>(o, v, typeof(Elastic.Clients.Elasticsearch.Serialization.TimeSpanMillisMarker)));
		writer.WriteProperty(options, PropWriteBufferOperationCount, value.WriteBufferOperationCount, null, null);
		writer.WriteProperty(options, PropWriteBufferSizeInBytes, value.WriteBufferSizeInBytes, null, null);
		writer.WriteEndObject();
	}
}