// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.CrossClusterReplication;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.CrossClusterReplication.Json.FollowerIndexParametersConverter))]
public sealed partial class FollowerIndexParameters
{
#if NET7_0_OR_GREATER
	public FollowerIndexParameters()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public FollowerIndexParameters()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FollowerIndexParameters(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The maximum number of outstanding reads requests from the remote cluster.
	/// </para>
	/// </summary>
	public long? MaxOutstandingReadRequests { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of outstanding write requests on the follower.
	/// </para>
	/// </summary>
	public int? MaxOutstandingWriteRequests { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of operations to pull per read from the remote cluster.
	/// </para>
	/// </summary>
	public int? MaxReadRequestOperationCount { get; set; }

	/// <summary>
	/// <para>
	/// The maximum size in bytes of per read of a batch of operations pulled from the remote cluster.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? MaxReadRequestSize { get; set; }

	/// <summary>
	/// <para>
	/// The maximum time to wait before retrying an operation that failed exceptionally. An exponential backoff strategy is employed when
	/// retrying.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? MaxRetryDelay { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of operations that can be queued for writing. When this limit is reached, reads from the remote cluster will be
	/// deferred until the number of queued operations goes below the limit.
	/// </para>
	/// </summary>
	public int? MaxWriteBufferCount { get; set; }

	/// <summary>
	/// <para>
	/// The maximum total bytes of operations that can be queued for writing. When this limit is reached, reads from the remote cluster will
	/// be deferred until the total bytes of queued operations goes below the limit.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? MaxWriteBufferSize { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of operations per bulk write request executed on the follower.
	/// </para>
	/// </summary>
	public int? MaxWriteRequestOperationCount { get; set; }

	/// <summary>
	/// <para>
	/// The maximum total bytes of operations per bulk write request executed on the follower.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.ByteSize? MaxWriteRequestSize { get; set; }

	/// <summary>
	/// <para>
	/// The maximum time to wait for new operations on the remote cluster when the follower index is synchronized with the leader index.
	/// When the timeout has elapsed, the poll for operations will return to the follower so that it can update some statistics.
	/// Then the follower will immediately attempt to read from the leader again.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Duration? ReadPollTimeout { get; set; }
}