// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.CrossClusterReplication;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.CrossClusterReplication.Json.FollowerIndexConverter))]
public sealed partial class FollowerIndex
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FollowerIndex(string followerIndexValue, string leaderIndex, string remoteCluster, Elastic.Clients.Elasticsearch.CrossClusterReplication.FollowerIndexStatus status)
	{
		FollowerIndexValue = followerIndexValue;
		LeaderIndex = leaderIndex;
		RemoteCluster = remoteCluster;
		Status = status;
	}
#if NET7_0_OR_GREATER
	public FollowerIndex()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public FollowerIndex()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal FollowerIndex(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The name of the follower index.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string FollowerIndexValue { get; set; }

	/// <summary>
	/// <para>
	/// The name of the index in the leader cluster that is followed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string LeaderIndex { get; set; }

	/// <summary>
	/// <para>
	/// An object that encapsulates cross-cluster replication parameters. If the follower index's status is paused, this object is omitted.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.CrossClusterReplication.FollowerIndexParameters? Parameters { get; set; }

	/// <summary>
	/// <para>
	/// The remote cluster that contains the leader index.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string RemoteCluster { get; set; }

	/// <summary>
	/// <para>
	/// The status of the index following: <c>active</c> or <c>paused</c>.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	Elastic.Clients.Elasticsearch.CrossClusterReplication.FollowerIndexStatus Status { get; set; }
}