// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.CrossClusterReplication;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.CrossClusterReplication.Json.AutoFollowStatsConverter))]
public sealed partial class AutoFollowStats
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AutoFollowStats(System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.CrossClusterReplication.AutoFollowedCluster> autoFollowedClusters, long numberOfFailedFollowIndices, long numberOfFailedRemoteClusterStateRequests, long numberOfSuccessfulFollowIndices, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.ErrorCause> recentAutoFollowErrors)
	{
		AutoFollowedClusters = autoFollowedClusters;
		NumberOfFailedFollowIndices = numberOfFailedFollowIndices;
		NumberOfFailedRemoteClusterStateRequests = numberOfFailedRemoteClusterStateRequests;
		NumberOfSuccessfulFollowIndices = numberOfSuccessfulFollowIndices;
		RecentAutoFollowErrors = recentAutoFollowErrors;
	}
#if NET7_0_OR_GREATER
	public AutoFollowStats()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public AutoFollowStats()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AutoFollowStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.CrossClusterReplication.AutoFollowedCluster> AutoFollowedClusters { get; set; }

	/// <summary>
	/// <para>
	/// The number of indices that the auto-follow coordinator failed to automatically follow.
	/// The causes of recent failures are captured in the logs of the elected master node and in the <c>auto_follow_stats.recent_auto_follow_errors</c> field.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long NumberOfFailedFollowIndices { get; set; }

	/// <summary>
	/// <para>
	/// The number of times that the auto-follow coordinator failed to retrieve the cluster state from a remote cluster registered in a collection of auto-follow patterns.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long NumberOfFailedRemoteClusterStateRequests { get; set; }

	/// <summary>
	/// <para>
	/// The number of indices that the auto-follow coordinator successfully followed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	long NumberOfSuccessfulFollowIndices { get; set; }

	/// <summary>
	/// <para>
	/// An array of objects representing failures by the auto-follow coordinator.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.ErrorCause> RecentAutoFollowErrors { get; set; }
}