// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.CrossClusterReplication.Json;

public sealed partial class AutoFollowStatsConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.CrossClusterReplication.AutoFollowStats>
{
	private static readonly System.Text.Json.JsonEncodedText PropAutoFollowedClusters = System.Text.Json.JsonEncodedText.Encode("auto_followed_clusters");
	private static readonly System.Text.Json.JsonEncodedText PropNumberOfFailedFollowIndices = System.Text.Json.JsonEncodedText.Encode("number_of_failed_follow_indices");
	private static readonly System.Text.Json.JsonEncodedText PropNumberOfFailedRemoteClusterStateRequests = System.Text.Json.JsonEncodedText.Encode("number_of_failed_remote_cluster_state_requests");
	private static readonly System.Text.Json.JsonEncodedText PropNumberOfSuccessfulFollowIndices = System.Text.Json.JsonEncodedText.Encode("number_of_successful_follow_indices");
	private static readonly System.Text.Json.JsonEncodedText PropRecentAutoFollowErrors = System.Text.Json.JsonEncodedText.Encode("recent_auto_follow_errors");

	public override Elastic.Clients.Elasticsearch.CrossClusterReplication.AutoFollowStats Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		reader.ValidateToken(System.Text.Json.JsonTokenType.StartObject);
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.CrossClusterReplication.AutoFollowedCluster>> propAutoFollowedClusters = default;
		LocalJsonValue<long> propNumberOfFailedFollowIndices = default;
		LocalJsonValue<long> propNumberOfFailedRemoteClusterStateRequests = default;
		LocalJsonValue<long> propNumberOfSuccessfulFollowIndices = default;
		LocalJsonValue<System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.ErrorCause>> propRecentAutoFollowErrors = default;
		while (reader.Read() && reader.TokenType is System.Text.Json.JsonTokenType.PropertyName)
		{
			if (propAutoFollowedClusters.TryReadProperty(ref reader, options, PropAutoFollowedClusters, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.CrossClusterReplication.AutoFollowedCluster> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.CrossClusterReplication.AutoFollowedCluster>(o, null)!))
			{
				continue;
			}

			if (propNumberOfFailedFollowIndices.TryReadProperty(ref reader, options, PropNumberOfFailedFollowIndices, null))
			{
				continue;
			}

			if (propNumberOfFailedRemoteClusterStateRequests.TryReadProperty(ref reader, options, PropNumberOfFailedRemoteClusterStateRequests, null))
			{
				continue;
			}

			if (propNumberOfSuccessfulFollowIndices.TryReadProperty(ref reader, options, PropNumberOfSuccessfulFollowIndices, null))
			{
				continue;
			}

			if (propRecentAutoFollowErrors.TryReadProperty(ref reader, options, PropRecentAutoFollowErrors, static System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.ErrorCause> (ref System.Text.Json.Utf8JsonReader r, System.Text.Json.JsonSerializerOptions o) => r.ReadCollectionValue<Elastic.Clients.Elasticsearch.ErrorCause>(o, null)!))
			{
				continue;
			}

			if (options.UnmappedMemberHandling is System.Text.Json.Serialization.JsonUnmappedMemberHandling.Skip)
			{
				reader.SafeSkip();
				continue;
			}

			throw new System.Text.Json.JsonException($"Unknown JSON property '{reader.GetString()}' for type '{typeToConvert.Name}'.");
		}

		reader.ValidateToken(System.Text.Json.JsonTokenType.EndObject);
		return new Elastic.Clients.Elasticsearch.CrossClusterReplication.AutoFollowStats(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance)
		{
			AutoFollowedClusters = propAutoFollowedClusters.Value,
			NumberOfFailedFollowIndices = propNumberOfFailedFollowIndices.Value,
			NumberOfFailedRemoteClusterStateRequests = propNumberOfFailedRemoteClusterStateRequests.Value,
			NumberOfSuccessfulFollowIndices = propNumberOfSuccessfulFollowIndices.Value,
			RecentAutoFollowErrors = propRecentAutoFollowErrors.Value
		};
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.CrossClusterReplication.AutoFollowStats value, System.Text.Json.JsonSerializerOptions options)
	{
		writer.WriteStartObject();
		writer.WriteProperty(options, PropAutoFollowedClusters, value.AutoFollowedClusters, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.CrossClusterReplication.AutoFollowedCluster> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.CrossClusterReplication.AutoFollowedCluster>(o, v, null));
		writer.WriteProperty(options, PropNumberOfFailedFollowIndices, value.NumberOfFailedFollowIndices, null, null);
		writer.WriteProperty(options, PropNumberOfFailedRemoteClusterStateRequests, value.NumberOfFailedRemoteClusterStateRequests, null, null);
		writer.WriteProperty(options, PropNumberOfSuccessfulFollowIndices, value.NumberOfSuccessfulFollowIndices, null, null);
		writer.WriteProperty(options, PropRecentAutoFollowErrors, value.RecentAutoFollowErrors, null, static (System.Text.Json.Utf8JsonWriter w, System.Text.Json.JsonSerializerOptions o, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.ErrorCause> v) => w.WriteCollectionValue<Elastic.Clients.Elasticsearch.ErrorCause>(o, v, null));
		writer.WriteEndObject();
	}
}