// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.CrossClusterReplication;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.CrossClusterReplication.Json.AutoFollowPatternSummaryConverter))]
public sealed partial class AutoFollowPatternSummary
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public AutoFollowPatternSummary(bool active, System.Collections.Generic.IReadOnlyCollection<string> leaderIndexExclusionPatterns, System.Collections.Generic.IReadOnlyCollection<string> leaderIndexPatterns, int maxOutstandingReadRequests, string remoteCluster)
	{
		Active = active;
		LeaderIndexExclusionPatterns = leaderIndexExclusionPatterns;
		LeaderIndexPatterns = leaderIndexPatterns;
		MaxOutstandingReadRequests = maxOutstandingReadRequests;
		RemoteCluster = remoteCluster;
	}
#if NET7_0_OR_GREATER
	public AutoFollowPatternSummary()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public AutoFollowPatternSummary()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal AutoFollowPatternSummary(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	public
#if NET7_0_OR_GREATER
	required
#endif
	bool Active { get; set; }

	/// <summary>
	/// <para>
	/// The name of follower index.
	/// </para>
	/// </summary>
	public string? FollowIndexPattern { get; set; }

	/// <summary>
	/// <para>
	/// An array of simple index patterns that can be used to exclude indices from being auto-followed.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<string> LeaderIndexExclusionPatterns { get; set; }

	/// <summary>
	/// <para>
	/// An array of simple index patterns to match against indices in the remote cluster specified by the remote_cluster field.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<string> LeaderIndexPatterns { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of outstanding reads requests from the remote cluster.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	int MaxOutstandingReadRequests { get; set; }

	/// <summary>
	/// <para>
	/// The remote cluster containing the leader indices to match against.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string RemoteCluster { get; set; }
}