// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.TermVectors;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.TermVectors.Json.FilterConverter))]
public sealed partial class Filter
{
#if NET7_0_OR_GREATER
	public Filter()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public Filter()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Filter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Ignore words which occur in more than this many docs.
	/// Defaults to unbounded.
	/// </para>
	/// </summary>
	public int? MaxDocFreq { get; set; }

	/// <summary>
	/// <para>
	/// The maximum number of terms that must be returned per field.
	/// </para>
	/// </summary>
	public int? MaxNumTerms { get; set; }

	/// <summary>
	/// <para>
	/// Ignore words with more than this frequency in the source doc.
	/// It defaults to unbounded.
	/// </para>
	/// </summary>
	public int? MaxTermFreq { get; set; }

	/// <summary>
	/// <para>
	/// The maximum word length above which words will be ignored.
	/// Defaults to unbounded.
	/// </para>
	/// </summary>
	public int? MaxWordLength { get; set; }

	/// <summary>
	/// <para>
	/// Ignore terms which do not occur in at least this many docs.
	/// </para>
	/// </summary>
	public int? MinDocFreq { get; set; }

	/// <summary>
	/// <para>
	/// Ignore words with less than this frequency in the source doc.
	/// </para>
	/// </summary>
	public int? MinTermFreq { get; set; }

	/// <summary>
	/// <para>
	/// The minimum word length below which words will be ignored.
	/// </para>
	/// </summary>
	public int? MinWordLength { get; set; }
}

public readonly partial struct FilterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.TermVectors.Filter Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FilterDescriptor(Elastic.Clients.Elasticsearch.Core.TermVectors.Filter instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public FilterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.TermVectors.Filter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.TermVectors.FilterDescriptor(Elastic.Clients.Elasticsearch.Core.TermVectors.Filter instance) => new Elastic.Clients.Elasticsearch.Core.TermVectors.FilterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.TermVectors.Filter(Elastic.Clients.Elasticsearch.Core.TermVectors.FilterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// Ignore words which occur in more than this many docs.
	/// Defaults to unbounded.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.TermVectors.FilterDescriptor MaxDocFreq(int? value)
	{
		Instance.MaxDocFreq = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum number of terms that must be returned per field.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.TermVectors.FilterDescriptor MaxNumTerms(int? value)
	{
		Instance.MaxNumTerms = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore words with more than this frequency in the source doc.
	/// It defaults to unbounded.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.TermVectors.FilterDescriptor MaxTermFreq(int? value)
	{
		Instance.MaxTermFreq = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The maximum word length above which words will be ignored.
	/// Defaults to unbounded.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.TermVectors.FilterDescriptor MaxWordLength(int? value)
	{
		Instance.MaxWordLength = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore terms which do not occur in at least this many docs.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.TermVectors.FilterDescriptor MinDocFreq(int? value)
	{
		Instance.MinDocFreq = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Ignore words with less than this frequency in the source doc.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.TermVectors.FilterDescriptor MinTermFreq(int? value)
	{
		Instance.MinTermFreq = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The minimum word length below which words will be ignored.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.TermVectors.FilterDescriptor MinWordLength(int? value)
	{
		Instance.MinWordLength = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.TermVectors.Filter Build(System.Action<Elastic.Clients.Elasticsearch.Core.TermVectors.FilterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Core.TermVectors.Filter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Core.TermVectors.FilterDescriptor(new Elastic.Clients.Elasticsearch.Core.TermVectors.Filter(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}