// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search;

/// <summary>
/// <para>
/// Defines how to fetch a source. Fetching can be disabled entirely, or the source can be filtered.
/// Used as a query parameter along with the <c>_source_includes</c> and <c>_source_excludes</c> parameters.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Search.Json.SourceConfigParamConverter))]
public sealed partial class SourceConfigParam : Elastic.Clients.Elasticsearch.Union<bool, Elastic.Clients.Elasticsearch.Fields>
{
	public SourceConfigParam(bool value) : base(value)
	{
	}

	public SourceConfigParam(Elastic.Clients.Elasticsearch.Fields value) : base(value)
	{
	}

	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam(bool value) => new Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam(value);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam(Elastic.Clients.Elasticsearch.Fields value) => new Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam(value);
}

public readonly partial struct SourceConfigParamFactory<TDocument>
{
	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam Fetch(bool value = true)
	{
		return new Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam(value);
	}

	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam Fields(Elastic.Clients.Elasticsearch.Fields value)
	{
		return new Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam(value);
	}

	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam Fields(params System.Linq.Expressions.Expression<System.Func<TDocument, object?>>[] value)
	{
		return new Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam(value);
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam Build(System.Func<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParamFactory<TDocument>, Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParamFactory<TDocument>();
		return action.Invoke(builder);
	}
}

public readonly partial struct SourceConfigParamFactory
{
	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam Fetch(bool value = true)
	{
		return new Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam(value);
	}

	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam Fields(Elastic.Clients.Elasticsearch.Fields value)
	{
		return new Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam(value);
	}

	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam Fields<T>(params System.Linq.Expressions.Expression<System.Func<T, object?>>[] value)
	{
		return new Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam(value);
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam Build(System.Func<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParamFactory, Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParam> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.Search.SourceConfigParamFactory();
		return action.Invoke(builder);
	}
}