// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search;

/// <summary>
/// <para>
/// Defines how to fetch a source. Fetching can be disabled entirely, or the source can be filtered.
/// </para>
/// </summary>
[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Search.Json.SourceConfigConverter))]
public sealed partial class SourceConfig : Elastic.Clients.Elasticsearch.Union<bool, Elastic.Clients.Elasticsearch.Core.Search.SourceFilter>
{
	public SourceConfig(bool value) : base(value)
	{
	}

	public SourceConfig(Elastic.Clients.Elasticsearch.Core.Search.SourceFilter value) : base(value)
	{
	}

	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.SourceConfig(bool value) => new Elastic.Clients.Elasticsearch.Core.Search.SourceConfig(value);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.SourceConfig(Elastic.Clients.Elasticsearch.Core.Search.SourceFilter value) => new Elastic.Clients.Elasticsearch.Core.Search.SourceConfig(value);
}

public readonly partial struct SourceConfigFactory<TDocument>
{
	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfig Fetch(bool value = true)
	{
		return new Elastic.Clients.Elasticsearch.Core.Search.SourceConfig(value);
	}

	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfig Filter(Elastic.Clients.Elasticsearch.Core.Search.SourceFilter value)
	{
		return new Elastic.Clients.Elasticsearch.Core.Search.SourceConfig(value);
	}

	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfig Filter()
	{
		return new Elastic.Clients.Elasticsearch.Core.Search.SourceConfig(Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor<TDocument>.Build(null));
	}

	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfig Filter(System.Action<Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor<TDocument>>? action)
	{
		return new Elastic.Clients.Elasticsearch.Core.Search.SourceConfig(Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor<TDocument>.Build(action));
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Search.SourceConfig Build(System.Func<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory<TDocument>, Elastic.Clients.Elasticsearch.Core.Search.SourceConfig> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory<TDocument>();
		return action.Invoke(builder);
	}
}

public readonly partial struct SourceConfigFactory
{
	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfig Fetch(bool value = true)
	{
		return new Elastic.Clients.Elasticsearch.Core.Search.SourceConfig(value);
	}

	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfig Filter(Elastic.Clients.Elasticsearch.Core.Search.SourceFilter value)
	{
		return new Elastic.Clients.Elasticsearch.Core.Search.SourceConfig(value);
	}

	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfig Filter()
	{
		return new Elastic.Clients.Elasticsearch.Core.Search.SourceConfig(Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor.Build(null));
	}

	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfig Filter(System.Action<Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor>? action)
	{
		return new Elastic.Clients.Elasticsearch.Core.Search.SourceConfig(Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor.Build(action));
	}

	public Elastic.Clients.Elasticsearch.Core.Search.SourceConfig Filter<T>(System.Action<Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor<T>>? action)
	{
		return new Elastic.Clients.Elasticsearch.Core.Search.SourceConfig(Elastic.Clients.Elasticsearch.Core.Search.SourceFilterDescriptor<T>.Build(action));
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Search.SourceConfig Build(System.Func<Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory, Elastic.Clients.Elasticsearch.Core.Search.SourceConfig> action)
	{
		var builder = new Elastic.Clients.Elasticsearch.Core.Search.SourceConfigFactory();
		return action.Invoke(builder);
	}
}