// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.SearchShards;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.SearchShards.Json.SearchShardsNodeAttributesConverter))]
public sealed partial class SearchShardsNodeAttributes
{
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SearchShardsNodeAttributes(System.Collections.Generic.IReadOnlyDictionary<string, string> attributes, string ephemeralId, string externalId, int maxIndexVersion, int minIndexVersion, string name, System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.NodeRole> roles, string transportAddress, string version)
	{
		Attributes = attributes;
		EphemeralId = ephemeralId;
		ExternalId = externalId;
		MaxIndexVersion = maxIndexVersion;
		MinIndexVersion = minIndexVersion;
		Name = name;
		Roles = roles;
		TransportAddress = transportAddress;
		Version = version;
	}
#if NET7_0_OR_GREATER
	public SearchShardsNodeAttributes()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	[System.Obsolete("The type contains required properties that must be initialized. Please use an alternative constructor to ensure all required values are properly set.")]
	public SearchShardsNodeAttributes()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SearchShardsNodeAttributes(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// Lists node attributes.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyDictionary<string, string> Attributes { get; set; }

	/// <summary>
	/// <para>
	/// The ephemeral ID of the node.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string EphemeralId { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string ExternalId { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	int MaxIndexVersion { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	int MinIndexVersion { get; set; }

	/// <summary>
	/// <para>
	/// The human-readable identifier of the node.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Name { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	System.Collections.Generic.IReadOnlyCollection<Elastic.Clients.Elasticsearch.NodeRole> Roles { get; set; }

	/// <summary>
	/// <para>
	/// The host and port where transport HTTP connections are accepted.
	/// </para>
	/// </summary>
	public
#if NET7_0_OR_GREATER
	required
#endif
	string TransportAddress { get; set; }
	public
#if NET7_0_OR_GREATER
	required
#endif
	string Version { get; set; }
}