// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.SearchMvt.Json;

public sealed partial class GridTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.SearchMvt.GridType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberCentroid = System.Text.Json.JsonEncodedText.Encode("centroid");
	private static readonly System.Text.Json.JsonEncodedText MemberGrid = System.Text.Json.JsonEncodedText.Encode("grid");
	private static readonly System.Text.Json.JsonEncodedText MemberPoint = System.Text.Json.JsonEncodedText.Encode("point");

	public override Elastic.Clients.Elasticsearch.Core.SearchMvt.GridType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberCentroid))
		{
			return Elastic.Clients.Elasticsearch.Core.SearchMvt.GridType.Centroid;
		}

		if (reader.ValueTextEquals(MemberGrid))
		{
			return Elastic.Clients.Elasticsearch.Core.SearchMvt.GridType.Grid;
		}

		if (reader.ValueTextEquals(MemberPoint))
		{
			return Elastic.Clients.Elasticsearch.Core.SearchMvt.GridType.Point;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberCentroid.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.SearchMvt.GridType.Centroid;
		}

		if (string.Equals(value, MemberGrid.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.SearchMvt.GridType.Grid;
		}

		if (string.Equals(value, MemberPoint.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.SearchMvt.GridType.Point;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.SearchMvt.GridType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.SearchMvt.GridType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Core.SearchMvt.GridType.Centroid:
				writer.WriteStringValue(MemberCentroid);
				break;
			case Elastic.Clients.Elasticsearch.Core.SearchMvt.GridType.Grid:
				writer.WriteStringValue(MemberGrid);
				break;
			case Elastic.Clients.Elasticsearch.Core.SearchMvt.GridType.Point:
				writer.WriteStringValue(MemberPoint);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.SearchMvt.GridType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Core.SearchMvt.GridType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.SearchMvt.GridType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}