// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.SearchMvt.Json;

public sealed partial class GridAggregationTypeConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.SearchMvt.GridAggregationType>
{
	private static readonly System.Text.Json.JsonEncodedText MemberGeohex = System.Text.Json.JsonEncodedText.Encode("geohex");
	private static readonly System.Text.Json.JsonEncodedText MemberGeotile = System.Text.Json.JsonEncodedText.Encode("geotile");

	public override Elastic.Clients.Elasticsearch.Core.SearchMvt.GridAggregationType Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberGeohex))
		{
			return Elastic.Clients.Elasticsearch.Core.SearchMvt.GridAggregationType.Geohex;
		}

		if (reader.ValueTextEquals(MemberGeotile))
		{
			return Elastic.Clients.Elasticsearch.Core.SearchMvt.GridAggregationType.Geotile;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberGeohex.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.SearchMvt.GridAggregationType.Geohex;
		}

		if (string.Equals(value, MemberGeotile.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.SearchMvt.GridAggregationType.Geotile;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.SearchMvt.GridAggregationType)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.SearchMvt.GridAggregationType value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Core.SearchMvt.GridAggregationType.Geohex:
				writer.WriteStringValue(MemberGeohex);
				break;
			case Elastic.Clients.Elasticsearch.Core.SearchMvt.GridAggregationType.Geotile:
				writer.WriteStringValue(MemberGeotile);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.SearchMvt.GridAggregationType)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Core.SearchMvt.GridAggregationType ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.SearchMvt.GridAggregationType value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}