// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search.Json;

public sealed partial class TotalHitsRelationConverter : System.Text.Json.Serialization.JsonConverter<Elastic.Clients.Elasticsearch.Core.Search.TotalHitsRelation>
{
	private static readonly System.Text.Json.JsonEncodedText MemberEq = System.Text.Json.JsonEncodedText.Encode("eq");
	private static readonly System.Text.Json.JsonEncodedText MemberGte = System.Text.Json.JsonEncodedText.Encode("gte");

	public override Elastic.Clients.Elasticsearch.Core.Search.TotalHitsRelation Read(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		if (reader.ValueTextEquals(MemberEq))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.TotalHitsRelation.Eq;
		}

		if (reader.ValueTextEquals(MemberGte))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.TotalHitsRelation.Gte;
		}

		var value = reader.GetString()!;
		if (string.Equals(value, MemberEq.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.TotalHitsRelation.Eq;
		}

		if (string.Equals(value, MemberGte.Value, System.StringComparison.OrdinalIgnoreCase))
		{
			return Elastic.Clients.Elasticsearch.Core.Search.TotalHitsRelation.Gte;
		}

		throw new System.Text.Json.JsonException($"Unknown member '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.Search.TotalHitsRelation)}'.");
	}

	public override void Write(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Search.TotalHitsRelation value, System.Text.Json.JsonSerializerOptions options)
	{
		switch (value)
		{
			case Elastic.Clients.Elasticsearch.Core.Search.TotalHitsRelation.Eq:
				writer.WriteStringValue(MemberEq);
				break;
			case Elastic.Clients.Elasticsearch.Core.Search.TotalHitsRelation.Gte:
				writer.WriteStringValue(MemberGte);
				break;
			default:
				throw new System.Text.Json.JsonException($"Invalid value '{value}' for enum '{nameof(Elastic.Clients.Elasticsearch.Core.Search.TotalHitsRelation)}'.");
		}
	}

	public override Elastic.Clients.Elasticsearch.Core.Search.TotalHitsRelation ReadAsPropertyName(ref System.Text.Json.Utf8JsonReader reader, System.Type typeToConvert, System.Text.Json.JsonSerializerOptions options)
	{
		return Read(ref reader, typeToConvert, options);
	}

	public override void WriteAsPropertyName(System.Text.Json.Utf8JsonWriter writer, Elastic.Clients.Elasticsearch.Core.Search.TotalHitsRelation value, System.Text.Json.JsonSerializerOptions options)
	{
		Write(writer, value, options);
	}
}