// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Search.Json.SuggesterConverter))]
public sealed partial class Suggester
{
#if NET7_0_OR_GREATER
	public Suggester()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public Suggester()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal Suggester(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The named suggesters
	/// </para>
	/// </summary>
	public System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Core.Search.FieldSuggester>? Suggesters { get; set; }

	/// <summary>
	/// <para>
	/// Global suggest text, to avoid repetition when the same text is used in several suggesters
	/// </para>
	/// </summary>
	public string? Text { get; set; }
}

public readonly partial struct SuggesterDescriptor<TDocument>
{
	internal Elastic.Clients.Elasticsearch.Core.Search.Suggester Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SuggesterDescriptor(Elastic.Clients.Elasticsearch.Core.Search.Suggester instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SuggesterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Search.Suggester(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<TDocument>(Elastic.Clients.Elasticsearch.Core.Search.Suggester instance) => new Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<TDocument>(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.Suggester(Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<TDocument> descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The named suggesters
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<TDocument> Suggesters(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Core.Search.FieldSuggester>? value)
	{
		Instance.Suggesters = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The named suggesters
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<TDocument> Suggesters()
	{
		Instance.Suggesters = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringFieldSuggester<TDocument>.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The named suggesters
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<TDocument> Suggesters(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringFieldSuggester<TDocument>>? action)
	{
		Instance.Suggesters = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringFieldSuggester<TDocument>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<TDocument> AddSuggester(string key, Elastic.Clients.Elasticsearch.Core.Search.FieldSuggester value)
	{
		Instance.Suggesters ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Core.Search.FieldSuggester>();
		Instance.Suggesters.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<TDocument> AddSuggester(string key, System.Action<Elastic.Clients.Elasticsearch.Core.Search.FieldSuggesterDescriptor<TDocument>> action)
	{
		Instance.Suggesters ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Core.Search.FieldSuggester>();
		Instance.Suggesters.Add(key, Elastic.Clients.Elasticsearch.Core.Search.FieldSuggesterDescriptor<TDocument>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Global suggest text, to avoid repetition when the same text is used in several suggesters
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<TDocument> Text(string? value)
	{
		Instance.Text = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Search.Suggester Build(System.Action<Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<TDocument>>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Core.Search.Suggester(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor<TDocument>(new Elastic.Clients.Elasticsearch.Core.Search.Suggester(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}

public readonly partial struct SuggesterDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.Search.Suggester Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SuggesterDescriptor(Elastic.Clients.Elasticsearch.Core.Search.Suggester instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SuggesterDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Search.Suggester(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor(Elastic.Clients.Elasticsearch.Core.Search.Suggester instance) => new Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.Suggester(Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The named suggesters
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor Suggesters(System.Collections.Generic.IDictionary<string, Elastic.Clients.Elasticsearch.Core.Search.FieldSuggester>? value)
	{
		Instance.Suggesters = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The named suggesters
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor Suggesters()
	{
		Instance.Suggesters = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringFieldSuggester.Build(null);
		return this;
	}

	/// <summary>
	/// <para>
	/// The named suggesters
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor Suggesters(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringFieldSuggester>? action)
	{
		Instance.Suggesters = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringFieldSuggester.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// The named suggesters
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor Suggesters<T>(System.Action<Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringFieldSuggester<T>>? action)
	{
		Instance.Suggesters = Elastic.Clients.Elasticsearch.Fluent.FluentDictionaryOfStringFieldSuggester<T>.Build(action);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor AddSuggester(string key, Elastic.Clients.Elasticsearch.Core.Search.FieldSuggester value)
	{
		Instance.Suggesters ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Core.Search.FieldSuggester>();
		Instance.Suggesters.Add(key, value);
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor AddSuggester(string key, System.Action<Elastic.Clients.Elasticsearch.Core.Search.FieldSuggesterDescriptor> action)
	{
		Instance.Suggesters ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Core.Search.FieldSuggester>();
		Instance.Suggesters.Add(key, Elastic.Clients.Elasticsearch.Core.Search.FieldSuggesterDescriptor.Build(action));
		return this;
	}

	public Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor AddSuggester<T>(string key, System.Action<Elastic.Clients.Elasticsearch.Core.Search.FieldSuggesterDescriptor<T>> action)
	{
		Instance.Suggesters ??= new System.Collections.Generic.Dictionary<string, Elastic.Clients.Elasticsearch.Core.Search.FieldSuggester>();
		Instance.Suggesters.Add(key, Elastic.Clients.Elasticsearch.Core.Search.FieldSuggesterDescriptor<T>.Build(action));
		return this;
	}

	/// <summary>
	/// <para>
	/// Global suggest text, to avoid repetition when the same text is used in several suggesters
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor Text(string? value)
	{
		Instance.Text = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Search.Suggester Build(System.Action<Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Core.Search.Suggester(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Core.Search.SuggesterDescriptor(new Elastic.Clients.Elasticsearch.Core.Search.Suggester(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}