// Licensed to Elasticsearch B.V under one or more agreements.
// Elasticsearch B.V licenses this file to you under the Apache 2.0 License.
// See the LICENSE file in the project root for more information.
//
// ███╗   ██╗ ██████╗ ████████╗██╗ ██████╗███████╗
// ████╗  ██║██╔═══██╗╚══██╔══╝██║██╔════╝██╔════╝
// ██╔██╗ ██║██║   ██║   ██║   ██║██║     █████╗
// ██║╚██╗██║██║   ██║   ██║   ██║██║     ██╔══╝
// ██║ ╚████║╚██████╔╝   ██║   ██║╚██████╗███████╗
// ╚═╝  ╚═══╝ ╚═════╝    ╚═╝   ╚═╝ ╚═════╝╚══════╝
// ------------------------------------------------
//
// This file is automatically generated.
// Please do not edit these files manually.
//
// ------------------------------------------------

#nullable restore

using System;
using System.Linq;
using Elastic.Clients.Elasticsearch.Serialization;

namespace Elastic.Clients.Elasticsearch.Core.Search;

[System.Text.Json.Serialization.JsonConverter(typeof(Elastic.Clients.Elasticsearch.Core.Search.Json.SuggestFuzzinessConverter))]
public sealed partial class SuggestFuzziness
{
#if NET7_0_OR_GREATER
	public SuggestFuzziness()
	{
	}
#endif
#if !NET7_0_OR_GREATER
	public SuggestFuzziness()
	{
	}
#endif
	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	internal SuggestFuzziness(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel sentinel)
	{
		_ = sentinel;
	}

	/// <summary>
	/// <para>
	/// The fuzziness factor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Fuzziness? Fuzziness { get; set; }

	/// <summary>
	/// <para>
	/// Minimum length of the input before fuzzy suggestions are returned.
	/// </para>
	/// </summary>
	public int? MinLength { get; set; }

	/// <summary>
	/// <para>
	/// Minimum length of the input, which is not checked for fuzzy alternatives.
	/// </para>
	/// </summary>
	public int? PrefixLength { get; set; }

	/// <summary>
	/// <para>
	/// If set to <c>true</c>, transpositions are counted as one change instead of two.
	/// </para>
	/// </summary>
	public bool? Transpositions { get; set; }

	/// <summary>
	/// <para>
	/// If <c>true</c>, all measurements (like fuzzy edit distance, transpositions, and lengths) are measured in Unicode code points instead of in bytes.
	/// This is slightly slower than raw bytes.
	/// </para>
	/// </summary>
	public bool? UnicodeAware { get; set; }
}

public readonly partial struct SuggestFuzzinessDescriptor
{
	internal Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzziness Instance { get; init; }

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SuggestFuzzinessDescriptor(Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzziness instance)
	{
		Instance = instance;
	}

	[System.Diagnostics.CodeAnalysis.SetsRequiredMembers]
	public SuggestFuzzinessDescriptor()
	{
		Instance = new Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzziness(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
	}

	public static explicit operator Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzzinessDescriptor(Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzziness instance) => new Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzzinessDescriptor(instance);
	public static implicit operator Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzziness(Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzzinessDescriptor descriptor) => descriptor.Instance;

	/// <summary>
	/// <para>
	/// The fuzziness factor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzzinessDescriptor Fuzziness(Elastic.Clients.Elasticsearch.Fuzziness? value)
	{
		Instance.Fuzziness = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// The fuzziness factor.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzzinessDescriptor Fuzziness(System.Func<Elastic.Clients.Elasticsearch.FuzzinessFactory, Elastic.Clients.Elasticsearch.Fuzziness> action)
	{
		Instance.Fuzziness = Elastic.Clients.Elasticsearch.FuzzinessFactory.Build(action);
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum length of the input before fuzzy suggestions are returned.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzzinessDescriptor MinLength(int? value)
	{
		Instance.MinLength = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// Minimum length of the input, which is not checked for fuzzy alternatives.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzzinessDescriptor PrefixLength(int? value)
	{
		Instance.PrefixLength = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If set to <c>true</c>, transpositions are counted as one change instead of two.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzzinessDescriptor Transpositions(bool? value = true)
	{
		Instance.Transpositions = value;
		return this;
	}

	/// <summary>
	/// <para>
	/// If <c>true</c>, all measurements (like fuzzy edit distance, transpositions, and lengths) are measured in Unicode code points instead of in bytes.
	/// This is slightly slower than raw bytes.
	/// </para>
	/// </summary>
	public Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzzinessDescriptor UnicodeAware(bool? value = true)
	{
		Instance.UnicodeAware = value;
		return this;
	}

	[System.Runtime.CompilerServices.MethodImpl(System.Runtime.CompilerServices.MethodImplOptions.AggressiveInlining)]
	internal static Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzziness Build(System.Action<Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzzinessDescriptor>? action)
	{
		if (action is null)
		{
			return new Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzziness(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance);
		}

		var builder = new Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzzinessDescriptor(new Elastic.Clients.Elasticsearch.Core.Search.SuggestFuzziness(Elastic.Clients.Elasticsearch.Serialization.JsonConstructorSentinel.Instance));
		action.Invoke(builder);
		return builder.Instance;
	}
}